/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationEpoch;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Station {
    List<StationEpoch> staList = new ArrayList<StationEpoch>();
    String netCode;
    String staCode;

    public Station(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("Station", xMLEventReader);
        this.netCode = StaxUtil.pullAttribute(startElement, "net_code");
        this.staCode = StaxUtil.pullAttribute(startElement, "sta_code");
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("StationEpoch")) {
                    this.staList.add(new StationEpoch(xMLEventReader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public String getNetCode() {
        return this.netCode;
    }

    public void setNetCode(String string) {
        this.netCode = string;
    }

    public String getStaCode() {
        return this.staCode;
    }

    public void setStaCode(String string) {
        this.staCode = string;
    }

    public List<StationEpoch> getStationEpochs() {
        return this.staList;
    }
}

