/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaMessage {
    XMLEventReader reader;
    String source;
    String sender;
    String module;
    String sentDate;
    String xmlSchemaLocation;
    NetworkIterator networks;
    private static final Logger logger = LoggerFactory.getLogger(StaMessage.class);

    public StaMessage(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        this.reader = xMLEventReader;
        StaxUtil.skipToStartElement(xMLEventReader);
        StartElement startElement = StaxUtil.expectStartElement("StaMessage", xMLEventReader);
        Attribute attribute = startElement.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
        this.xmlSchemaLocation = attribute.getValue();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("Source")) {
                    this.source = StaxUtil.pullText(xMLEventReader, "Source");
                    continue;
                }
                if (string.equals("Sender")) {
                    this.sender = StaxUtil.pullText(xMLEventReader, "Sender");
                    continue;
                }
                if (string.equals("Module")) {
                    this.module = StaxUtil.pullText(xMLEventReader, "Module");
                    continue;
                }
                if (string.equals("SentDate")) {
                    this.sentDate = StaxUtil.pullText(xMLEventReader, "SentDate");
                    continue;
                }
                if (string.equals("Network")) {
                    this.networks = new NetworkIterator(xMLEventReader);
                    break;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String string) {
        this.sender = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(String string) {
        this.sentDate = string;
    }

    public NetworkIterator getNetworks() {
        return this.networks;
    }

    public void closeReader() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            logger.warn("problem closing underlying XMLEventReader.", (Throwable)xMLStreamException);
        }
    }

    public String getXmlSchemaLocation() {
        return this.xmlSchemaLocation;
    }

    public void setXmlSchemaLocation(String string) {
        this.xmlSchemaLocation = string;
    }

    public boolean checkSchemaVersion() {
        return this.xmlSchemaLocation.split(" ")[0].equals("http://www.data.scec.org/xml/station/20120307/");
    }
}

