/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Site {
    String name;
    String description;
    String town;
    String county;
    String state;
    String country;

    public Site(String string, String string2, String string3, String string4, String string5, String string6) {
        this.name = string;
        this.description = string2;
        this.town = string3;
        this.county = string4;
        this.state = string5;
        this.country = string6;
    }

    public Site(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("Site", xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("Town")) {
                    this.town = StaxUtil.pullText(xMLEventReader, "Town");
                    continue;
                }
                if (string.equals("Name")) {
                    this.name = StaxUtil.pullText(xMLEventReader, "Name");
                    continue;
                }
                if (string.equals("Description")) {
                    this.description = StaxUtil.pullText(xMLEventReader, "Description");
                    continue;
                }
                if (string.equals("County")) {
                    this.county = StaxUtil.pullText(xMLEventReader, "County");
                    continue;
                }
                if (string.equals("State")) {
                    this.state = StaxUtil.pullText(xMLEventReader, "State");
                    continue;
                }
                if (string.equals("Country")) {
                    this.country = StaxUtil.pullText(xMLEventReader, "Country");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getTown() {
        return this.town;
    }

    public void setTown(String string) {
        this.town = string;
    }

    public String getCounty() {
        return this.county;
    }

    public void setCounty(String string) {
        this.county = string;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) {
        this.state = string;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String string) {
        this.country = string;
    }
}

