/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ResponseListElement {
    private float frequency;
    private float amplitude;
    private float phase;

    public ResponseListElement(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("PolesZeros", xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("Frequency")) {
                    this.frequency = StaxUtil.pullFloat(xMLEventReader, "Frequency");
                    continue;
                }
                if (string.equals("Amplitude")) {
                    this.amplitude = StaxUtil.pullFloat(xMLEventReader, "Amplitude");
                    continue;
                }
                if (string.equals("Phase")) {
                    this.phase = StaxUtil.pullFloat(xMLEventReader, "Phase");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public float getFrequency() {
        return this.frequency;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public float getPhase() {
        return this.phase;
    }
}

