/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.ResponseListElement;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ResponseList
extends AbstractResponseType {
    private List<ResponseListElement> responseElements = new ArrayList<ResponseListElement>();

    public ResponseList(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("PolesZeros", xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("InputUnits")) {
                    this.inputUnits = StaxUtil.pullText(xMLEventReader, "InputUnits");
                    continue;
                }
                if (string.equals("OutputUnits")) {
                    this.outputUnits = StaxUtil.pullText(xMLEventReader, "OutputUnits");
                    continue;
                }
                if (string.equals("ResponseListElement")) {
                    this.responseElements.add(new ResponseListElement(xMLEventReader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public List<ResponseListElement> getResponseElements() {
        return this.responseElements;
    }
}

