/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.Coefficients;
import edu.sc.seis.seisFile.stationxml.Decimation;
import edu.sc.seis.seisFile.stationxml.FIR;
import edu.sc.seis.seisFile.stationxml.GainSensitivity;
import edu.sc.seis.seisFile.stationxml.Generic;
import edu.sc.seis.seisFile.stationxml.PolesZeros;
import edu.sc.seis.seisFile.stationxml.Polynomial;
import edu.sc.seis.seisFile.stationxml.ResponseList;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Response {
    private Integer stage;
    private String stageDescription;
    private AbstractResponseType responseItem;
    private Decimation decimation;
    private GainSensitivity stageSensitivity;

    public Response(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("Response", xMLEventReader);
        this.stage = StaxUtil.pullIntAttribute(startElement, "stage");
        try {
            this.stageDescription = StaxUtil.pullAttribute(startElement, "stage_description");
        }
        catch (StationXMLException stationXMLException) {
            // empty catch block
        }
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("PolesZeros")) {
                    this.responseItem = new PolesZeros(xMLEventReader);
                    continue;
                }
                if (string.equals("Coefficients")) {
                    this.responseItem = new Coefficients(xMLEventReader);
                    continue;
                }
                if (string.equals("ResponseList")) {
                    this.responseItem = new ResponseList(xMLEventReader);
                    continue;
                }
                if (string.equals("Generic")) {
                    this.responseItem = new Generic(xMLEventReader);
                    continue;
                }
                if (string.equals("FIR")) {
                    this.responseItem = new FIR(xMLEventReader);
                    continue;
                }
                if (string.equals("Polynomial")) {
                    this.responseItem = new Polynomial(xMLEventReader);
                    continue;
                }
                if (string.equals("Decimation")) {
                    this.decimation = new Decimation(xMLEventReader);
                    continue;
                }
                if (string.equals("StageSensitivity")) {
                    this.stageSensitivity = new GainSensitivity(xMLEventReader, "StageSensitivity");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public Integer getStage() {
        return this.stage;
    }

    public String getStageDescription() {
        return this.stageDescription;
    }

    public AbstractResponseType getResponseItem() {
        return this.responseItem;
    }

    public Decimation getDecimation() {
        return this.decimation;
    }

    public GainSensitivity getStageSensitivity() {
        return this.stageSensitivity;
    }
}

