/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Polynomial
extends AbstractResponseType {
    private String approximationType;
    private Float freqLowerBound;
    private float freqUpperBound;
    private float approxLowerBound;
    private float approxUpperBound;
    private float maxError;
    private List<Float> coefficientList = new ArrayList<Float>();

    public Polynomial(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("PolesZeros", xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("ApproximationType")) {
                    this.approximationType = StaxUtil.pullText(xMLEventReader, "ApproximationType");
                    continue;
                }
                if (string.equals("InputUnits")) {
                    this.inputUnits = StaxUtil.pullText(xMLEventReader, "InputUnits");
                    continue;
                }
                if (string.equals("OutputUnits")) {
                    this.outputUnits = StaxUtil.pullText(xMLEventReader, "OutputUnits");
                    continue;
                }
                if (string.equals("FreqLowerBound")) {
                    this.freqLowerBound = Float.valueOf(StaxUtil.pullFloat(xMLEventReader, "FreqLowerBound"));
                    continue;
                }
                if (string.equals("FreqUpperBound")) {
                    this.freqUpperBound = StaxUtil.pullFloat(xMLEventReader, "FreqUpperBound");
                    continue;
                }
                if (string.equals("ApproxLowerBound")) {
                    this.approxLowerBound = StaxUtil.pullFloat(xMLEventReader, "ApproxLowerBound");
                    continue;
                }
                if (string.equals("ApproxUpperBound")) {
                    this.approxUpperBound = StaxUtil.pullFloat(xMLEventReader, "ApproxUpperBound");
                    continue;
                }
                if (string.equals("MaxError")) {
                    this.maxError = StaxUtil.pullFloat(xMLEventReader, "MaxError");
                    continue;
                }
                if (string.equals("Coefficient")) {
                    this.coefficientList.add(Float.valueOf(StaxUtil.pullFloat(xMLEventReader, "Coefficient")));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public String getApproximationType() {
        return this.approximationType;
    }

    public Float getFreqLowerBound() {
        return this.freqLowerBound;
    }

    public float getFreqUpperBound() {
        return this.freqUpperBound;
    }

    public float getApproxLowerBound() {
        return this.approxLowerBound;
    }

    public float getApproxUpperBound() {
        return this.approxUpperBound;
    }

    public float getMaxError() {
        return this.maxError;
    }

    public List<Float> getCoefficientList() {
        return this.coefficientList;
    }
}

