/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.Pole;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import edu.sc.seis.seisFile.stationxml.Zero;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PolesZeros
extends AbstractResponseType {
    private String comment;
    private String pzTransferType;
    private float normalizationFactor;
    private float normalizationFreq;
    private List<Pole> poleList = new ArrayList<Pole>();
    private List<Zero> zeroList = new ArrayList<Zero>();

    public PolesZeros(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("PolesZeros", xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("Comment")) {
                    this.comment = StaxUtil.pullText(xMLEventReader, "Comment");
                    continue;
                }
                if (string.equals("InputUnits")) {
                    this.inputUnits = StaxUtil.pullText(xMLEventReader, "InputUnits");
                    continue;
                }
                if (string.equals("OutputUnits")) {
                    this.outputUnits = StaxUtil.pullText(xMLEventReader, "OutputUnits");
                    continue;
                }
                if (string.equals("PzTransferFunctionType")) {
                    this.pzTransferType = StaxUtil.pullText(xMLEventReader, "PzTransferFunctionType");
                    continue;
                }
                if (string.equals("NormalizationFactor")) {
                    this.normalizationFactor = StaxUtil.pullFloat(xMLEventReader, "NormalizationFactor");
                    continue;
                }
                if (string.equals("NormalizationFreq")) {
                    this.normalizationFreq = StaxUtil.pullFloat(xMLEventReader, "NormalizationFreq");
                    continue;
                }
                if (string.equals("Pole")) {
                    this.poleList.add(new Pole(xMLEventReader));
                    continue;
                }
                if (string.equals("Zero")) {
                    this.zeroList.add(new Zero(xMLEventReader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public String getComment() {
        return this.comment;
    }

    public String getPzTransferType() {
        return this.pzTransferType;
    }

    public float getNormalizationFactor() {
        return this.normalizationFactor;
    }

    public float getNormalizationFreq() {
        return this.normalizationFreq;
    }

    public List<Pole> getPoleList() {
        return this.poleList;
    }

    public List<Zero> getZeroList() {
        return this.zeroList;
    }
}

