/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.ListStationIterator;
import edu.sc.seis.seisFile.stationxml.Station;
import edu.sc.seis.seisFile.stationxml.StationIterator;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Network {
    String netCode;
    String startDate;
    String endDate;
    String description;
    int totalNumStations;
    int selectedNumStations;
    StationIterator stations = new ListStationIterator(new ArrayList<Station>());

    public Network(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("Network", xMLEventReader);
        this.netCode = StaxUtil.pullAttribute(startElement, "net_code");
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("StartDate")) {
                    this.startDate = StaxUtil.pullText(xMLEventReader, "StartDate");
                    continue;
                }
                if (string.equals("EndDate")) {
                    this.endDate = StaxUtil.pullText(xMLEventReader, "EndDate");
                    continue;
                }
                if (string.equals("Description")) {
                    this.description = StaxUtil.pullText(xMLEventReader, "Description");
                    continue;
                }
                if (string.equals("TotalNumberStations")) {
                    this.totalNumStations = StaxUtil.pullInt(xMLEventReader, "TotalNumberStations");
                    continue;
                }
                if (string.equals("SelectedNumberStations")) {
                    this.selectedNumStations = StaxUtil.pullInt(xMLEventReader, "SelectedNumberStations");
                    continue;
                }
                if (string.equals("Station")) {
                    this.stations = new StationIterator(xMLEventReader);
                    break;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public String getNetCode() {
        return this.netCode;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getDescription() {
        return this.description;
    }

    public StationIterator getStations() {
        return this.stations;
    }

    public int getTotalNumStations() {
        return this.totalNumStations;
    }

    public int getSelectedNumStations() {
        return this.selectedNumStations;
    }
}

