/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class InstrumentSensitivity {
    float sensitivityValue;
    float frequency;
    String sensitivityUnits;

    public InstrumentSensitivity(float f, String string, float f2) {
        this.sensitivityValue = f;
        this.sensitivityUnits = string;
        this.frequency = f2;
    }

    public InstrumentSensitivity(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("InstrumentSensitivity", xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("SensitivityValue")) {
                    this.sensitivityValue = StaxUtil.pullFloat(xMLEventReader, "SensitivityValue");
                    continue;
                }
                if (string.equals("Frequency")) {
                    this.frequency = StaxUtil.pullFloat(xMLEventReader, "Frequency");
                    continue;
                }
                if (string.equals("SensitivityUnits")) {
                    this.sensitivityUnits = StaxUtil.pullText(xMLEventReader, "SensitivityUnits");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public float getSensitivityValue() {
        return this.sensitivityValue;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public String getSensitivityUnits() {
        return this.sensitivityUnits;
    }
}

