/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class GainSensitivity {
    float sensitivityValue;
    float frequency;
    String sensitivityUnits;

    public GainSensitivity(float f, String string, float f2) {
        this.sensitivityValue = f;
        this.sensitivityUnits = string;
        this.frequency = f2;
    }

    public GainSensitivity(XMLEventReader xMLEventReader, String string) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement(string, xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string2 = xMLEvent.asStartElement().getName().getLocalPart();
                if (string2.equals("SensitivityValue")) {
                    this.sensitivityValue = StaxUtil.pullFloat(xMLEventReader, "SensitivityValue");
                    continue;
                }
                if (string2.equals("Frequency")) {
                    this.frequency = StaxUtil.pullFloat(xMLEventReader, "Frequency");
                    continue;
                }
                if (string2.equals("SensitivityUnits")) {
                    this.sensitivityUnits = StaxUtil.pullText(xMLEventReader, "SensitivityUnits");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public float getSensitivityValue() {
        return this.sensitivityValue;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public String getSensitivityUnits() {
        return this.sensitivityUnits;
    }

    @Deprecated
    public String getGainUnits() {
        return this.getSensitivityUnits();
    }
}

