/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class FIR
extends AbstractResponseType {
    String responseName;
    String symmetry;
    List<Float> numeratorCoefficientList = new ArrayList<Float>();

    public FIR(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("PolesZeros", xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("ResponseName")) {
                    this.responseName = StaxUtil.pullText(xMLEventReader, "ResponseName");
                    continue;
                }
                if (string.equals("InputUnits")) {
                    this.inputUnits = StaxUtil.pullText(xMLEventReader, "InputUnits");
                    continue;
                }
                if (string.equals("OutputUnits")) {
                    this.outputUnits = StaxUtil.pullText(xMLEventReader, "OutputUnits");
                    continue;
                }
                if (string.equals("Symmetry")) {
                    this.symmetry = StaxUtil.pullText(xMLEventReader, "Symmetry");
                    continue;
                }
                if (string.equals("NumeratorCoefficient")) {
                    this.numeratorCoefficientList.add(Float.valueOf(StaxUtil.pullFloat(xMLEventReader, "NormalizationFactor")));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public String getResponseName() {
        return this.responseName;
    }

    public String getSymmetry() {
        return this.symmetry;
    }

    public List<Float> getNumeratorCoefficientList() {
        return this.numeratorCoefficientList;
    }
}

