/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Decimation {
    private float inputSampleRate;
    private int factor;
    private int offset;
    private float delay;
    private float correction;

    public Decimation(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("Decimation", xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("InputSampleRate")) {
                    this.inputSampleRate = StaxUtil.pullFloat(xMLEventReader, "InputSampleRate");
                    continue;
                }
                if (string.equals("Factor")) {
                    this.factor = StaxUtil.pullInt(xMLEventReader, "Factor");
                    continue;
                }
                if (string.equals("Offset")) {
                    this.offset = StaxUtil.pullInt(xMLEventReader, "Offset");
                    continue;
                }
                if (string.equals("Delay")) {
                    this.delay = StaxUtil.pullFloat(xMLEventReader, "Delay");
                    continue;
                }
                if (string.equals("Correction")) {
                    this.correction = StaxUtil.pullFloat(xMLEventReader, "Correction");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public float getInputSampleRate() {
        return this.inputSampleRate;
    }

    public int getFactor() {
        return this.factor;
    }

    public int getOffset() {
        return this.offset;
    }

    public float getDelay() {
        return this.delay;
    }

    public float getCorrection() {
        return this.correction;
    }
}

