/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.AbstractResponseType;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Coefficients
extends AbstractResponseType {
    private static String cfTransferType;
    List<Float> numeratorList = new ArrayList<Float>();
    List<Float> denominatorList = new ArrayList<Float>();

    public Coefficients(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("Coefficients", xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("InputUnits")) {
                    this.inputUnits = StaxUtil.pullText(xMLEventReader, "InputUnits");
                    continue;
                }
                if (string.equals("OutputUnits")) {
                    this.outputUnits = StaxUtil.pullText(xMLEventReader, "OutputUnits");
                    continue;
                }
                if (string.equals("CfTransferFunctionType")) {
                    cfTransferType = StaxUtil.pullText(xMLEventReader, "CfTransferFunctionType");
                    continue;
                }
                if (string.equals("Numerator")) {
                    this.numeratorList.add(Float.valueOf(StaxUtil.pullFloat(xMLEventReader, "Numerator")));
                    continue;
                }
                if (string.equals("Demoninator")) {
                    this.denominatorList.add(Float.valueOf(StaxUtil.pullFloat(xMLEventReader, "Demoninator")));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public static String getCfTransferType() {
        return cfTransferType;
    }

    public List<Float> getNumeratorList() {
        return this.numeratorList;
    }

    public List<Float> getDenominatorList() {
        return this.denominatorList;
    }
}

