/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.Epoch;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Channel {
    List<Epoch> chanEpochList = new ArrayList<Epoch>();
    String chanCode;
    String locCode;
    String creationDate;

    public Channel(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("Channel", xMLEventReader);
        this.locCode = StaxUtil.pullAttribute(startElement, "loc_code");
        this.chanCode = StaxUtil.pullAttribute(startElement, "chan_code");
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("Epoch")) {
                    this.chanEpochList.add(new Epoch(xMLEventReader));
                    continue;
                }
                if (string.equals("CreationDate")) {
                    this.creationDate = StaxUtil.pullText(xMLEventReader, "CreationDate");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public List<Epoch> getChanEpochList() {
        return this.chanEpochList;
    }

    public String getChanCode() {
        return this.chanCode;
    }

    public String getLocCode() {
        return this.locCode;
    }

    public String getCreationDate() {
        return this.creationDate;
    }
}

