/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.seedlink;

import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.seedlink.SeedlinkException;
import edu.sc.seis.seisFile.seedlink.SeedlinkPacket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class SeedlinkReader {
    PushbackInputStream in;
    DataInputStream inData;
    BufferedOutputStream out;
    private Socket socket;
    boolean verbose = false;
    String host;
    int port;
    int timeoutSeconds;
    List<String> sentCommands = new ArrayList<String>();
    private PrintWriter verboseWriter;
    public static final String DEFAULT_HOST = "rtserve.iris.washington.edu";
    public static final int DEFAULT_PORT = 18000;
    public static final int DEFAULT_TIMEOUT_SECOND = 120;
    public static final String INFO_ID = "ID";
    public static final String INFO_CAPABILITIES = "CAPABILITIES";
    public static final String INFO_STATIONS = "STATIONS";
    public static final String INFO_STREAMS = "STREAMS";
    public static final String INFO_GAPS = "GAPS";
    public static final String INFO_CONNECTIONS = "CONNECTIONS";
    public static final String INFO_ALL = "ALL";

    public SeedlinkReader() throws UnknownHostException, IOException {
        this(DEFAULT_HOST, 18000);
    }

    public SeedlinkReader(String string) throws UnknownHostException, IOException {
        this(string, 18000);
    }

    public SeedlinkReader(String string, int n) throws UnknownHostException, IOException {
        this(string, n, 120);
    }

    public SeedlinkReader(String string, int n, int n2) throws UnknownHostException, IOException {
        this(string, n, n2, false);
    }

    public SeedlinkReader(String string, int n, int n2, boolean bl) throws UnknownHostException, IOException {
        this.host = string;
        this.port = n;
        this.verbose = bl;
        this.timeoutSeconds = n2;
        this.initConnection();
    }

    private void initConnection() throws UnknownHostException, IOException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setSoTimeout(this.timeoutSeconds * 1000);
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
        this.in = new PushbackInputStream(new BufferedInputStream(this.socket.getInputStream()), 3);
        this.inData = new DataInputStream(this.in);
    }

    public boolean hasNext() throws IOException {
        if (!this.isConnected()) {
            return false;
        }
        byte[] byArray = new byte[]{(byte)this.in.read(), (byte)this.in.read(), (byte)this.in.read()};
        String string = new String(byArray);
        if (string.equals("END")) {
            return false;
        }
        this.in.unread(byArray);
        return true;
    }

    public boolean available() throws IOException {
        if (!this.isConnected()) {
            return false;
        }
        return this.in.available() > 256;
    }

    public SeedlinkPacket next() throws IOException, SeedlinkException {
        if (this.isVerbose()) {
            this.verboseWriter.println("next(): blocking read for 520 bytes, available=" + this.in.available());
        }
        if (!this.hasNext()) {
            throw new SeedlinkException("no more seed link packets from last command");
        }
        byte[] byArray = new byte[520];
        this.inData.readFully(byArray);
        SeedlinkPacket seedlinkPacket = new SeedlinkPacket(byArray);
        if (this.isVerbose()) {
            String string = "";
            try {
                DataRecord dataRecord = seedlinkPacket.getMiniSeed();
                string = " Got a packet: " + seedlinkPacket.getSeqNum() + "  " + dataRecord.getHeader().getNetworkCode() + "  " + dataRecord.getHeader().getStationIdentifier() + "  " + dataRecord.getHeader().getLocationIdentifier() + "  " + dataRecord.getHeader().getChannelIdentifier() + "  " + dataRecord.getHeader().getStartTime();
            }
            catch (SeedFormatException seedFormatException) {
                string = "SeedFormatExcpetion parsing packet: " + seedlinkPacket.getSeqNum() + seedFormatException.getMessage();
            }
            this.verboseWriter.println(string);
        }
        return seedlinkPacket;
    }

    public void info(String string) throws IOException {
        this.send("INFO " + string);
    }

    public void endHandshake() throws IOException {
        this.send("END");
    }

    public void close() {
        try {
            this.send("BYE");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.in.close();
            this.out.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = null;
        this.in = null;
        this.out = null;
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public void reconnect() throws IOException, SeedlinkException {
        this.close();
        this.initConnection();
        for (String string : this.sentCommands) {
            this.internalSendCmd(string);
        }
        this.endHandshake();
    }

    String[] sendHello() throws IOException, SeedlinkException {
        this.send("HELLO");
        String[] stringArray = new String[]{this.readLine(), this.readLine()};
        return stringArray;
    }

    String readLine() throws IOException, SeedlinkException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.in.read();
        while (n != 13) {
            while (n != 13 && this.in.available() > 0) {
                stringBuffer.append((char)n);
                n = this.in.read();
                if (n != -1) continue;
                throw new SeedlinkException("read returned -1, socket closed???");
            }
            if (!this.isVerbose()) continue;
            this.verboseWriter.println(stringBuffer);
        }
        n = this.in.read();
        if (n != 10) {
            throw new SeedlinkException("Got \\r but not followed by \\n buf: '" + stringBuffer.toString() + "' next: " + n);
        }
        return stringBuffer.toString();
    }

    public void sendCmd(String string) throws IOException, SeedlinkException {
        this.internalSendCmd(string);
        this.sentCommands.add(string);
    }

    protected void internalSendCmd(String string) throws IOException, SeedlinkException {
        this.send(string);
        String string2 = this.readLine();
        if (!string2.equals("OK")) {
            throw new SeedlinkException("Command " + string + " did not return OK");
        }
    }

    void send(String string) throws IOException {
        if (this.isVerbose()) {
            this.verboseWriter.println("send '" + string + "'");
        }
        this.out.write((string + "\r").getBytes());
        this.out.flush();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
        if (this.verboseWriter == null) {
            this.verboseWriter = new PrintWriter(System.out);
        }
    }

    public PrintWriter getVerboseWriter() {
        return this.verboseWriter;
    }

    public void setVerboseWriter(PrintWriter printWriter) {
        this.verboseWriter = printWriter;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

