/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

import edu.sc.seis.seisFile.sac.SacConstants;
import edu.sc.seis.seisFile.sac.SacHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;

public class SacTimeSeries {
    private SacHeader header;
    private float[] y;
    private float[] x;
    private float[] real;
    private float[] imaginary;
    private float[] amp;
    private float[] phase;
    private int numPtsRead = 0;

    public SacTimeSeries() {
    }

    public SacTimeSeries(SacHeader sacHeader, float[] fArray) {
        this.header = sacHeader;
        sacHeader.setIftype(1);
        sacHeader.setLeven(1);
        this.setY(fArray);
    }

    public SacTimeSeries(File file) throws FileNotFoundException, IOException {
        this.read(file);
    }

    public SacTimeSeries(String string) throws FileNotFoundException, IOException {
        this(new File(string));
    }

    public SacTimeSeries(DataInput dataInput) throws IOException {
        this.read(dataInput);
    }

    public float[] getY() {
        return this.y;
    }

    public void setY(float[] fArray) {
        this.y = fArray;
        this.getHeader().setNpts(fArray.length);
        if (!SacConstants.isUndef(this.getHeader().getDelta()) && !SacConstants.isUndef(this.getHeader().getB())) {
            this.getHeader().setE(this.getHeader().getB() + (float)(fArray.length - 1) * this.getHeader().getDelta());
        }
    }

    public float[] getX() {
        return this.x;
    }

    public void setX(float[] fArray) {
        this.x = fArray;
    }

    public float[] getReal() {
        return this.real;
    }

    public void setReal(float[] fArray) {
        this.real = fArray;
    }

    public float[] getImaginary() {
        return this.imaginary;
    }

    public void setImaginary(float[] fArray) {
        this.imaginary = fArray;
    }

    public float[] getAmp() {
        return this.amp;
    }

    public void setAmp(float[] fArray) {
        this.amp = fArray;
    }

    public float[] getPhase() {
        return this.phase;
    }

    public void setPhase(float[] fArray) {
        this.phase = fArray;
    }

    public SacHeader getHeader() {
        return this.header;
    }

    public void printHeader(PrintWriter printWriter) {
        this.header.printHeader(printWriter);
    }

    public int getNumPtsRead() {
        return this.numPtsRead;
    }

    public void read(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        this.read(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws FileNotFoundException, IOException {
        if (file.length() < 632L) {
            throw new IOException(file.getName() + " does not appear to be a sac file! File size (" + file.length() + " is less than sac's header size (" + 632 + ")");
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            this.header = new SacHeader(dataInputStream);
            if (this.header.getLeven() == 1 && this.header.getIftype() == 1) {
                if (file.length() != (long)(this.header.getNpts() * 4 + 632)) {
                    throw new IOException(file.getName() + " does not appear to be a sac file! npts(" + this.header.getNpts() + ") * 4 + header(" + 632 + ") !=  file length=" + file.length() + "\n  as linux: npts(" + SacHeader.swapBytes(this.header.getNpts()) + ")*4 + header(" + 632 + ") !=  file length=" + file.length());
                }
            } else if (this.header.getLeven() == 1 || this.header.getIftype() == 3 || this.header.getIftype() == 2) {
                if (file.length() != (long)(this.header.getNpts() * 4 * 2 + 632)) {
                    throw new IOException(file.getName() + " does not appear to be a amph or rlim sac file! npts(" + this.header.getNpts() + ") * 4 *2 + header(" + 632 + ") !=  file length=" + file.length() + "\n  as linux: npts(" + SacHeader.swapBytes(this.header.getNpts()) + ")*4*2 + header(" + 632 + ") !=  file length=" + file.length());
                }
            } else if (this.header.getLeven() == 0 && file.length() != (long)(this.header.getNpts() * 4 * 2 + 632)) {
                throw new IOException(file.getName() + " does not appear to be a uneven sac file! npts(" + this.header.getNpts() + ") * 4 *2 + header(" + 632 + ") !=  file length=" + file.length() + "\n  as linux: npts(" + SacHeader.swapBytes(this.header.getNpts()) + ")*4*2 + header(" + 632 + ") !=  file length=" + file.length());
            }
            this.readData(dataInputStream);
        }
        finally {
            dataInputStream.close();
        }
    }

    public void read(DataInput dataInput) throws IOException {
        this.header = new SacHeader(dataInput);
        this.readData(dataInput);
    }

    protected void readData(DataInput dataInput) throws IOException {
        this.y = new float[this.header.getNpts()];
        SacTimeSeries.readDataArray(dataInput, this.y, this.header.getByteOrder());
        if (this.header.getLeven() == 0 || this.header.getIftype() == 2 || this.header.getIftype() == 3) {
            this.x = new float[this.header.getNpts()];
            SacTimeSeries.readDataArray(dataInput, this.x, this.header.getByteOrder());
            if (this.header.getIftype() == 2) {
                this.real = this.y;
                this.imaginary = this.x;
            }
            if (this.header.getIftype() == 3) {
                this.amp = this.y;
                this.phase = this.x;
            }
        }
        this.numPtsRead = this.header.getNpts();
    }

    public static void readSomeData(DataInput dataInput, float[] fArray, boolean bl) throws IOException {
        SacTimeSeries.readDataArray(dataInput, fArray, bl);
    }

    public static int skipSamples(DataInput dataInput, int n) throws IOException {
        return dataInput.skipBytes(n * 4) / 4;
    }

    private static void readDataArray(DataInput dataInput, float[] fArray, boolean bl) throws IOException {
        byte[] byArray = new byte[fArray.length * 4];
        int n = 0;
        int n2 = 0;
        dataInput.readFully(byArray);
        while (n < fArray.length) {
            if (!bl) {
                fArray[n++] = Float.intBitsToFloat(((byArray[n2++] & 0xFF) << 0) + ((byArray[n2++] & 0xFF) << 8) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 24));
                continue;
            }
            fArray[n++] = Float.intBitsToFloat(((byArray[n2++] & 0xFF) << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + ((byArray[n2++] & 0xFF) << 0));
        }
    }

    public void write(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        this.write(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws FileNotFoundException, IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            this.header.writeHeader(dataOutputStream);
            this.writeData(dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
    }

    public void writeData(DataOutput dataOutput) throws IOException {
        int n;
        for (n = 0; n < this.header.getNpts(); ++n) {
            this.header.writeFloat(dataOutput, this.y[n]);
        }
        if (this.header.getLeven() == 0 || this.header.getIftype() == 2 || this.header.getIftype() == 3) {
            for (n = 0; n < this.header.getNpts(); ++n) {
                this.header.writeFloat(dataOutput, this.x[n]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendData(File file, float[] fArray) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            SacHeader sacHeader = new SacHeader(randomAccessFile);
            if (sacHeader.getLeven() == 0 || sacHeader.getIftype() == 2 || sacHeader.getIftype() == 3) {
                randomAccessFile.close();
                throw new IOException("Can only append to evenly sampled sac files, ie only Y");
            }
            int n = sacHeader.getNpts();
            sacHeader.setNpts(sacHeader.getNpts() + fArray.length);
            sacHeader.setE((float)(sacHeader.getNpts() - 1) * sacHeader.getDelta());
            randomAccessFile.seek(0L);
            sacHeader.writeHeader(randomAccessFile);
            randomAccessFile.skipBytes(n * 4);
            if (!sacHeader.getByteOrder()) {
                for (int i = 0; i < fArray.length; ++i) {
                    randomAccessFile.writeInt(SacHeader.swapBytes(Float.floatToRawIntBits(fArray[i])));
                }
            } else {
                for (int i = 0; i < fArray.length; ++i) {
                    randomAccessFile.writeFloat(fArray[i]);
                }
            }
        }
        finally {
            randomAccessFile.close();
        }
    }

    public static void main(String[] stringArray) {
        SacTimeSeries sacTimeSeries = new SacTimeSeries();
        if (stringArray.length != 1) {
            System.out.println("Usage: java SacTimeSeries sacsourcefile ");
            return;
        }
        try {
            sacTimeSeries.read(stringArray[0]);
            System.out.println("stla original: " + sacTimeSeries.header.getStla() + " npts=" + sacTimeSeries.header.getNpts());
            sacTimeSeries.write("outsacfile");
            sacTimeSeries.read("outsacfile");
            System.out.println("stla after read little endian: " + sacTimeSeries.header.getStla() + " npts=" + sacTimeSeries.header.getNpts());
            System.out.println("Done writing");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + stringArray[0] + " doesn't exist.");
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }
}

