/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

import edu.sc.seis.seisFile.sac.Complex;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class SacPoleZero {
    private Complex[] poles;
    private Complex[] zeros;
    private float constant;
    static String POLES = "POLES";
    static String ZEROS = "ZEROS";
    static String CONSTANT = "CONSTANT";
    protected static DecimalFormat formatter = new DecimalFormat(" 0.0000;-0.0000");
    protected static DecimalFormat constantFormatter = new DecimalFormat("0.0#######E00");

    public SacPoleZero(BufferedReader bufferedReader) throws IOException {
        this.read(bufferedReader);
    }

    public SacPoleZero(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.read(bufferedReader);
        bufferedReader.close();
    }

    public SacPoleZero(Complex[] complexArray, Complex[] complexArray2, float f) {
        this.poles = complexArray;
        this.zeros = complexArray2;
        this.constant = f;
    }

    public float getConstant() {
        return this.constant;
    }

    public Complex[] getPoles() {
        return this.poles;
    }

    public Complex[] getZeros() {
        return this.zeros;
    }

    public String toString() {
        int n;
        String string = ZEROS + " " + this.zeros.length + "\n";
        for (n = 0; n < this.zeros.length; ++n) {
            string = string + formatter.format(this.zeros[n].getReal()) + " " + formatter.format(this.zeros[n].getImaginary()) + "\n";
        }
        string = string + POLES + " " + this.poles.length + "\n";
        for (n = 0; n < this.poles.length; ++n) {
            string = string + formatter.format(this.poles[n].getReal()) + " " + formatter.format(this.poles[n].getImaginary()) + "\n";
        }
        string = string + CONSTANT + " " + constantFormatter.format(this.constant) + "\n";
        return string;
    }

    protected void read(BufferedReader bufferedReader) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string.trim());
        }
        Complex[] complexArray = new Complex[]{};
        Complex[] complexArray2 = new Complex[]{};
        float f = 1.0f;
        Iterator iterator = arrayList.iterator();
        String string2 = SacPoleZero.nextLine(iterator);
        while (!string2.equals("")) {
            int n;
            int n2;
            String[] stringArray;
            if (string2.startsWith(POLES)) {
                stringArray = string2.substring(POLES.length()).trim();
                n2 = Integer.parseInt((String)stringArray);
                complexArray = SacPoleZero.initCmplx(n2);
                string2 = SacPoleZero.nextLine(iterator);
                for (n = 0; n < complexArray.length && iterator.hasNext() && string2.matches("^-?\\d+\\.\\d+\\s+-?\\d+\\.\\d+"); ++n) {
                    complexArray[n] = SacPoleZero.parseCmplx(string2);
                    string2 = SacPoleZero.nextLine(iterator);
                }
                continue;
            }
            if (string2.startsWith(ZEROS)) {
                stringArray = string2.substring(ZEROS.length()).trim();
                n2 = Integer.parseInt((String)stringArray);
                complexArray2 = SacPoleZero.initCmplx(n2);
                string2 = SacPoleZero.nextLine(iterator);
                for (n = 0; n < complexArray2.length && iterator.hasNext() && string2.matches("^-?\\d+\\.\\d+\\s+-?\\d+\\.\\d+"); ++n) {
                    complexArray2[n] = SacPoleZero.parseCmplx(string2);
                    string2 = SacPoleZero.nextLine(iterator);
                }
                continue;
            }
            if (string2.startsWith(CONSTANT)) {
                string2 = string2.replaceAll("\\s+", " ");
                stringArray = string2.split(" ");
                f = Float.parseFloat(stringArray[1]);
                string2 = SacPoleZero.nextLine(iterator);
                continue;
            }
            throw new IOException("Unknown line in SAC polezero file: " + string2);
        }
        this.poles = complexArray;
        this.zeros = complexArray2;
        this.constant = f;
    }

    private static String nextLine(Iterator iterator) {
        if (iterator.hasNext()) {
            return (String)iterator.next();
        }
        return "";
    }

    public static Complex[] initCmplx(int n) {
        Complex[] complexArray = new Complex[n];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray[i] = new Complex(0.0, 0.0);
        }
        return complexArray;
    }

    static Complex parseCmplx(String string) throws IOException {
        string = string.trim().replaceAll("\\s+", " ");
        String[] stringArray = string.split(" ");
        return new Complex(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]));
    }

    public boolean close(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object instanceof SacPoleZero) {
            SacPoleZero sacPoleZero = (SacPoleZero)object;
            if (!SacPoleZero.close(sacPoleZero.constant, this.constant)) {
                System.out.println("const not close");
                return false;
            }
            return this.closeButConstant(object);
        }
        return false;
    }

    public boolean closeButConstant(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object instanceof SacPoleZero) {
            int n;
            SacPoleZero sacPoleZero = (SacPoleZero)object;
            if (sacPoleZero.poles.length != this.poles.length || sacPoleZero.zeros.length != this.zeros.length) {
                return false;
            }
            for (n = 0; n < this.poles.length; ++n) {
                if (SacPoleZero.closeFourDigit(sacPoleZero.poles[n], this.poles[n])) continue;
                System.out.println("pole " + n + " not equal" + sacPoleZero.poles[n].getImaginary() + " " + this.poles[n].getImaginary() + " " + sacPoleZero.poles[n].getReal() + " " + this.poles[n].getReal());
                return false;
            }
            for (n = 0; n < this.zeros.length; ++n) {
                if (SacPoleZero.closeFourDigit(sacPoleZero.zeros[n], this.zeros[n])) continue;
                System.out.println("zero " + n + " not equal");
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean close(double d, double d2) {
        if (Math.abs(d - d2) / d > 1.0E-4) {
            System.out.println("fail close " + d + " " + d2 + " " + Math.abs(d - d2) / d + " ratio=" + d / d2);
            return false;
        }
        return true;
    }

    private static boolean closeFourDigit(Complex complex, Complex complex2) {
        return SacPoleZero.closeFourDigit(complex.getReal(), complex2.getReal()) && SacPoleZero.closeFourDigit(complex.getImaginary(), complex2.getImaginary());
    }

    private static boolean closeFourDigit(double d, double d2) {
        if (Math.abs(d - d2) > 1.0E-4) {
            System.out.println("fail closeFourDigit " + d + " " + d2 + " " + Math.abs(d - d2) + " ratio=" + d / d2);
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object instanceof SacPoleZero) {
            int n;
            SacPoleZero sacPoleZero = (SacPoleZero)object;
            if ((double)(Math.abs(sacPoleZero.constant - this.constant) / this.constant) > 0.001) {
                return false;
            }
            if (sacPoleZero.poles.length != this.poles.length || sacPoleZero.zeros.length != this.zeros.length) {
                return false;
            }
            for (n = 0; n < this.poles.length; ++n) {
                if (sacPoleZero.poles[n].getImaginary() == this.poles[n].getImaginary() && sacPoleZero.poles[n].getReal() == this.poles[n].getReal()) continue;
                return false;
            }
            for (n = 0; n < this.zeros.length; ++n) {
                if (sacPoleZero.zeros[n].getImaginary() == this.zeros[n].getImaginary() && sacPoleZero.zeros[n].getReal() == this.zeros[n].getReal()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n;
        int n2 = 17;
        n2 = 29 * n2 + this.poles.length;
        n2 = 31 * n2 + this.zeros.length;
        for (n = 0; n < this.poles.length; ++n) {
            n2 = 37 * n2 + this.poles[n].hashCode();
        }
        for (n = 0; n < this.zeros.length; ++n) {
            n2 = 43 * n2 + this.zeros[n].hashCode();
        }
        return n2;
    }
}

