/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class SacIncrementalloader {
    DataInput in;
    SacHeader header;
    int chunkSize;
    int ptsRead = 0;
    String filename;
    public static final int DEFAULT_SIZE = 10000;

    public SacIncrementalloader(String string) throws IOException {
        this(string, 10000);
    }

    public SacIncrementalloader(String string, int n) throws IOException {
        this.filename = string;
        this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        this.header = new SacHeader(this.in);
    }

    public SacHeader getHeader() {
        return this.header;
    }

    public float[] next() throws IOException {
        int n = this.header.getNpts() - this.ptsRead;
        float[] fArray = new float[this.chunkSize < n ? this.chunkSize : n];
        if (this.ptsRead < this.header.getNpts()) {
            SacTimeSeries.readSomeData(this.in, fArray, this.header.getByteOrder());
            this.ptsRead += fArray.length;
            return fArray;
        }
        return new float[0];
    }

    public void skip(int n) throws IOException {
        int n2 = this.header.getNpts() - this.ptsRead;
        this.in.skipBytes(n < n2 ? n : n2);
        this.ptsRead += n < n2 ? n : n2;
    }

    public int getNumRemaining() {
        return this.header.getNpts() - this.ptsRead;
    }

    public int getNumRead() {
        return this.ptsRead;
    }
}

