/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;

public class SacHeader {
    public static final DecimalFormat decimalFormat = new DecimalFormat("#####.####");
    boolean byteOrder = true;
    private float delta = -12345.0f;
    private float depmin = -12345.0f;
    private float depmax = -12345.0f;
    private float scale = -12345.0f;
    private float odelta = -12345.0f;
    private float b = -12345.0f;
    private float e = -12345.0f;
    private float o = -12345.0f;
    private float a = -12345.0f;
    private float fmt = -12345.0f;
    private float t0 = -12345.0f;
    private float t1 = -12345.0f;
    private float t2 = -12345.0f;
    private float t3 = -12345.0f;
    private float t4 = -12345.0f;
    private float t5 = -12345.0f;
    private float t6 = -12345.0f;
    private float t7 = -12345.0f;
    private float t8 = -12345.0f;
    private float t9 = -12345.0f;
    private float f = -12345.0f;
    private float resp0 = -12345.0f;
    private float resp1 = -12345.0f;
    private float resp2 = -12345.0f;
    private float resp3 = -12345.0f;
    private float resp4 = -12345.0f;
    private float resp5 = -12345.0f;
    private float resp6 = -12345.0f;
    private float resp7 = -12345.0f;
    private float resp8 = -12345.0f;
    private float resp9 = -12345.0f;
    private float stla = -12345.0f;
    private float stlo = -12345.0f;
    private float stel = -12345.0f;
    private float stdp = -12345.0f;
    private float evla = -12345.0f;
    private float evlo = -12345.0f;
    private float evel = -12345.0f;
    private float evdp = -12345.0f;
    private float mag = -12345.0f;
    private float user0 = -12345.0f;
    private float user1 = -12345.0f;
    private float user2 = -12345.0f;
    private float user3 = -12345.0f;
    private float user4 = -12345.0f;
    private float user5 = -12345.0f;
    private float user6 = -12345.0f;
    private float user7 = -12345.0f;
    private float user8 = -12345.0f;
    private float user9 = -12345.0f;
    private float dist = -12345.0f;
    private float az = -12345.0f;
    private float baz = -12345.0f;
    private float gcarc = -12345.0f;
    private float sb = -12345.0f;
    private float sdelta = -12345.0f;
    private float depmen = -12345.0f;
    private float cmpaz = -12345.0f;
    private float cmpinc = -12345.0f;
    private float xminimum = -12345.0f;
    private float xmaximum = -12345.0f;
    private float yminimum = -12345.0f;
    private float ymaximum = -12345.0f;
    private float unused6 = -12345.0f;
    private float unused7 = -12345.0f;
    private float unused8 = -12345.0f;
    private float unused9 = -12345.0f;
    private float unused10 = -12345.0f;
    private float unused11 = -12345.0f;
    private float unused12 = -12345.0f;
    private int nzyear = -12345;
    private int nzjday = -12345;
    private int nzhour = -12345;
    private int nzmin = -12345;
    private int nzsec = -12345;
    private int nzmsec = -12345;
    private int nvhdr = 6;
    private int norid = -12345;
    private int nevid = -12345;
    private int npts = -12345;
    private int nsnpts = -12345;
    private int nwfid = -12345;
    private int nxsize = -12345;
    private int nysize = -12345;
    private int unused15 = -12345;
    private int iftype = -12345;
    private int idep = -12345;
    private int iztype = -12345;
    private int unused16 = -12345;
    private int iinst = -12345;
    private int istreg = -12345;
    private int ievreg = -12345;
    private int ievtyp = -12345;
    private int iqual = -12345;
    private int isynth = -12345;
    private int imagtyp = -12345;
    private int imagsrc = -12345;
    private int unused19 = -12345;
    private int unused20 = -12345;
    private int unused21 = -12345;
    private int unused22 = -12345;
    private int unused23 = -12345;
    private int unused24 = -12345;
    private int unused25 = -12345;
    private int unused26 = -12345;
    private int leven = -12345;
    private int lpspol = -12345;
    private int lovrok = -12345;
    private int lcalda = -12345;
    private int unused27 = -12345;
    private String kstnm = "-12345  ";
    private String kevnm = "-12345          ";
    private String khole = "-12345  ";
    private String ko = "-12345  ";
    private String ka = "-12345  ";
    private String kt0 = "-12345  ";
    private String kt1 = "-12345  ";
    private String kt2 = "-12345  ";
    private String kt3 = "-12345  ";
    private String kt4 = "-12345  ";
    private String kt5 = "-12345  ";
    private String kt6 = "-12345  ";
    private String kt7 = "-12345  ";
    private String kt8 = "-12345  ";
    private String kt9 = "-12345  ";
    private String kf = "-12345  ";
    private String kuser0 = "-12345  ";
    private String kuser1 = "-12345  ";
    private String kuser2 = "-12345  ";
    private String kcmpnm = "-12345  ";
    private String knetwk = "-12345  ";
    private String kdatrd = "-12345  ";
    private String kinst = "-12345  ";

    public SacHeader() {
    }

    public SacHeader(String string) throws IOException {
        this(new File(string));
    }

    public SacHeader(DataInput dataInput) throws IOException {
        this.readHeader(dataInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SacHeader(File file) throws IOException {
        if (file.length() < 632L) {
            throw new IOException(file.getName() + " does not appear to be a sac file! File size (" + file.length() + " is less than sac's header size (" + 632 + ")");
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            this.readHeader(dataInputStream);
        }
        finally {
            dataInputStream.close();
        }
    }

    public static SacHeader createEmptyEvenSampledTimeSeriesHeader() {
        SacHeader sacHeader = new SacHeader();
        sacHeader.leven = 1;
        sacHeader.iftype = 1;
        sacHeader.npts = 0;
        sacHeader.b = 0.0f;
        sacHeader.e = 0.0f;
        sacHeader.idep = 5;
        return sacHeader;
    }

    void readHeader(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[632];
        dataInput.readFully(byArray);
        if (byArray[304] == 6 && byArray[305] == 0 && byArray[306] == 0 && byArray[307] == 0) {
            this.byteOrder = false;
            for (int i = 0; i < 440; i += 4) {
                byte by = byArray[i];
                byArray[i] = byArray[i + 3];
                byArray[i + 3] = by;
                by = byArray[i + 1];
                byArray[i + 1] = byArray[i + 2];
                byArray[i + 2] = by;
            }
        } else if (byArray[304] != 0 || byArray[305] != 0 || byArray[306] != 0 || byArray[307] != 6) {
            throw new IOException("Does not appear to be a SAC file, NVHDR header bytes should be (int) 6 but found " + byArray[304] + " " + byArray[305] + " " + byArray[306] + " " + byArray[307]);
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        this.delta = dataInputStream.readFloat();
        this.depmin = dataInputStream.readFloat();
        this.depmax = dataInputStream.readFloat();
        this.scale = dataInputStream.readFloat();
        this.odelta = dataInputStream.readFloat();
        this.b = dataInputStream.readFloat();
        this.e = dataInputStream.readFloat();
        this.o = dataInputStream.readFloat();
        this.a = dataInputStream.readFloat();
        this.fmt = dataInputStream.readFloat();
        this.t0 = dataInputStream.readFloat();
        this.t1 = dataInputStream.readFloat();
        this.t2 = dataInputStream.readFloat();
        this.t3 = dataInputStream.readFloat();
        this.t4 = dataInputStream.readFloat();
        this.t5 = dataInputStream.readFloat();
        this.t6 = dataInputStream.readFloat();
        this.t7 = dataInputStream.readFloat();
        this.t8 = dataInputStream.readFloat();
        this.t9 = dataInputStream.readFloat();
        this.f = dataInputStream.readFloat();
        this.resp0 = dataInputStream.readFloat();
        this.resp1 = dataInputStream.readFloat();
        this.resp2 = dataInputStream.readFloat();
        this.resp3 = dataInputStream.readFloat();
        this.resp4 = dataInputStream.readFloat();
        this.resp5 = dataInputStream.readFloat();
        this.resp6 = dataInputStream.readFloat();
        this.resp7 = dataInputStream.readFloat();
        this.resp8 = dataInputStream.readFloat();
        this.resp9 = dataInputStream.readFloat();
        this.stla = dataInputStream.readFloat();
        this.stlo = dataInputStream.readFloat();
        this.stel = dataInputStream.readFloat();
        this.stdp = dataInputStream.readFloat();
        this.evla = dataInputStream.readFloat();
        this.evlo = dataInputStream.readFloat();
        this.evel = dataInputStream.readFloat();
        this.evdp = dataInputStream.readFloat();
        this.mag = dataInputStream.readFloat();
        this.user0 = dataInputStream.readFloat();
        this.user1 = dataInputStream.readFloat();
        this.user2 = dataInputStream.readFloat();
        this.user3 = dataInputStream.readFloat();
        this.user4 = dataInputStream.readFloat();
        this.user5 = dataInputStream.readFloat();
        this.user6 = dataInputStream.readFloat();
        this.user7 = dataInputStream.readFloat();
        this.user8 = dataInputStream.readFloat();
        this.user9 = dataInputStream.readFloat();
        this.dist = dataInputStream.readFloat();
        this.az = dataInputStream.readFloat();
        this.baz = dataInputStream.readFloat();
        this.gcarc = dataInputStream.readFloat();
        this.sb = dataInputStream.readFloat();
        this.sdelta = dataInputStream.readFloat();
        this.depmen = dataInputStream.readFloat();
        this.cmpaz = dataInputStream.readFloat();
        this.cmpinc = dataInputStream.readFloat();
        this.xminimum = dataInputStream.readFloat();
        this.xmaximum = dataInputStream.readFloat();
        this.yminimum = dataInputStream.readFloat();
        this.ymaximum = dataInputStream.readFloat();
        this.unused6 = dataInputStream.readFloat();
        this.unused7 = dataInputStream.readFloat();
        this.unused8 = dataInputStream.readFloat();
        this.unused9 = dataInputStream.readFloat();
        this.unused10 = dataInputStream.readFloat();
        this.unused11 = dataInputStream.readFloat();
        this.unused12 = dataInputStream.readFloat();
        this.nzyear = dataInputStream.readInt();
        this.nzjday = dataInputStream.readInt();
        this.nzhour = dataInputStream.readInt();
        this.nzmin = dataInputStream.readInt();
        this.nzsec = dataInputStream.readInt();
        this.nzmsec = dataInputStream.readInt();
        this.nvhdr = dataInputStream.readInt();
        this.norid = dataInputStream.readInt();
        this.nevid = dataInputStream.readInt();
        this.npts = dataInputStream.readInt();
        this.nsnpts = dataInputStream.readInt();
        this.nwfid = dataInputStream.readInt();
        this.nxsize = dataInputStream.readInt();
        this.nysize = dataInputStream.readInt();
        this.unused15 = dataInputStream.readInt();
        this.iftype = dataInputStream.readInt();
        this.idep = dataInputStream.readInt();
        this.iztype = dataInputStream.readInt();
        this.unused16 = dataInputStream.readInt();
        this.iinst = dataInputStream.readInt();
        this.istreg = dataInputStream.readInt();
        this.ievreg = dataInputStream.readInt();
        this.ievtyp = dataInputStream.readInt();
        this.iqual = dataInputStream.readInt();
        this.isynth = dataInputStream.readInt();
        this.imagtyp = dataInputStream.readInt();
        this.imagsrc = dataInputStream.readInt();
        this.unused19 = dataInputStream.readInt();
        this.unused20 = dataInputStream.readInt();
        this.unused21 = dataInputStream.readInt();
        this.unused22 = dataInputStream.readInt();
        this.unused23 = dataInputStream.readInt();
        this.unused24 = dataInputStream.readInt();
        this.unused25 = dataInputStream.readInt();
        this.unused26 = dataInputStream.readInt();
        this.leven = dataInputStream.readInt();
        this.lpspol = dataInputStream.readInt();
        this.lovrok = dataInputStream.readInt();
        this.lcalda = dataInputStream.readInt();
        this.unused27 = dataInputStream.readInt();
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[16];
        dataInputStream.readFully(byArray2);
        this.kstnm = new String(byArray2);
        dataInputStream.readFully(byArray3);
        this.kevnm = new String(byArray3);
        dataInputStream.readFully(byArray2);
        this.khole = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.ko = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.ka = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kt0 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kt1 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kt2 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kt3 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kt4 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kt5 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kt6 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kt7 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kt8 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kt9 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kf = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kuser0 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kuser1 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kuser2 = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kcmpnm = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.knetwk = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kdatrd = new String(byArray2);
        dataInputStream.readFully(byArray2);
        this.kinst = new String(byArray2);
    }

    final void writeFloat(DataOutput dataOutput, float f) throws IOException {
        if (!this.byteOrder) {
            dataOutput.writeInt(SacHeader.swapBytes(Float.floatToRawIntBits(f)));
        } else {
            dataOutput.writeFloat(f);
        }
    }

    private final void writeInt(DataOutput dataOutput, int n) throws IOException {
        if (!this.byteOrder) {
            dataOutput.writeInt(SacHeader.swapBytes(n));
        } else {
            dataOutput.writeInt(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeader(File file) throws FileNotFoundException, IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            this.writeHeader(dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
    }

    public void writeHeader(DataOutput dataOutput) throws IOException {
        this.writeFloat(dataOutput, this.delta);
        this.writeFloat(dataOutput, this.depmin);
        this.writeFloat(dataOutput, this.depmax);
        this.writeFloat(dataOutput, this.scale);
        this.writeFloat(dataOutput, this.odelta);
        this.writeFloat(dataOutput, this.b);
        this.writeFloat(dataOutput, this.e);
        this.writeFloat(dataOutput, this.o);
        this.writeFloat(dataOutput, this.a);
        this.writeFloat(dataOutput, this.fmt);
        this.writeFloat(dataOutput, this.t0);
        this.writeFloat(dataOutput, this.t1);
        this.writeFloat(dataOutput, this.t2);
        this.writeFloat(dataOutput, this.t3);
        this.writeFloat(dataOutput, this.t4);
        this.writeFloat(dataOutput, this.t5);
        this.writeFloat(dataOutput, this.t6);
        this.writeFloat(dataOutput, this.t7);
        this.writeFloat(dataOutput, this.t8);
        this.writeFloat(dataOutput, this.t9);
        this.writeFloat(dataOutput, this.f);
        this.writeFloat(dataOutput, this.resp0);
        this.writeFloat(dataOutput, this.resp1);
        this.writeFloat(dataOutput, this.resp2);
        this.writeFloat(dataOutput, this.resp3);
        this.writeFloat(dataOutput, this.resp4);
        this.writeFloat(dataOutput, this.resp5);
        this.writeFloat(dataOutput, this.resp6);
        this.writeFloat(dataOutput, this.resp7);
        this.writeFloat(dataOutput, this.resp8);
        this.writeFloat(dataOutput, this.resp9);
        this.writeFloat(dataOutput, this.stla);
        this.writeFloat(dataOutput, this.stlo);
        this.writeFloat(dataOutput, this.stel);
        this.writeFloat(dataOutput, this.stdp);
        this.writeFloat(dataOutput, this.evla);
        this.writeFloat(dataOutput, this.evlo);
        this.writeFloat(dataOutput, this.evel);
        this.writeFloat(dataOutput, this.evdp);
        this.writeFloat(dataOutput, this.mag);
        this.writeFloat(dataOutput, this.user0);
        this.writeFloat(dataOutput, this.user1);
        this.writeFloat(dataOutput, this.user2);
        this.writeFloat(dataOutput, this.user3);
        this.writeFloat(dataOutput, this.user4);
        this.writeFloat(dataOutput, this.user5);
        this.writeFloat(dataOutput, this.user6);
        this.writeFloat(dataOutput, this.user7);
        this.writeFloat(dataOutput, this.user8);
        this.writeFloat(dataOutput, this.user9);
        this.writeFloat(dataOutput, this.dist);
        this.writeFloat(dataOutput, this.az);
        this.writeFloat(dataOutput, this.baz);
        this.writeFloat(dataOutput, this.gcarc);
        this.writeFloat(dataOutput, this.sb);
        this.writeFloat(dataOutput, this.sdelta);
        this.writeFloat(dataOutput, this.depmen);
        this.writeFloat(dataOutput, this.cmpaz);
        this.writeFloat(dataOutput, this.cmpinc);
        this.writeFloat(dataOutput, this.xminimum);
        this.writeFloat(dataOutput, this.xmaximum);
        this.writeFloat(dataOutput, this.yminimum);
        this.writeFloat(dataOutput, this.ymaximum);
        this.writeFloat(dataOutput, this.unused6);
        this.writeFloat(dataOutput, this.unused7);
        this.writeFloat(dataOutput, this.unused8);
        this.writeFloat(dataOutput, this.unused9);
        this.writeFloat(dataOutput, this.unused10);
        this.writeFloat(dataOutput, this.unused11);
        this.writeFloat(dataOutput, this.unused12);
        this.writeInt(dataOutput, this.nzyear);
        this.writeInt(dataOutput, this.nzjday);
        this.writeInt(dataOutput, this.nzhour);
        this.writeInt(dataOutput, this.nzmin);
        this.writeInt(dataOutput, this.nzsec);
        this.writeInt(dataOutput, this.nzmsec);
        this.writeInt(dataOutput, this.nvhdr);
        this.writeInt(dataOutput, this.norid);
        this.writeInt(dataOutput, this.nevid);
        this.writeInt(dataOutput, this.npts);
        this.writeInt(dataOutput, this.nsnpts);
        this.writeInt(dataOutput, this.nwfid);
        this.writeInt(dataOutput, this.nxsize);
        this.writeInt(dataOutput, this.nysize);
        this.writeInt(dataOutput, this.unused15);
        this.writeInt(dataOutput, this.iftype);
        this.writeInt(dataOutput, this.idep);
        this.writeInt(dataOutput, this.iztype);
        this.writeInt(dataOutput, this.unused16);
        this.writeInt(dataOutput, this.iinst);
        this.writeInt(dataOutput, this.istreg);
        this.writeInt(dataOutput, this.ievreg);
        this.writeInt(dataOutput, this.ievtyp);
        this.writeInt(dataOutput, this.iqual);
        this.writeInt(dataOutput, this.isynth);
        this.writeInt(dataOutput, this.imagtyp);
        this.writeInt(dataOutput, this.imagsrc);
        this.writeInt(dataOutput, this.unused19);
        this.writeInt(dataOutput, this.unused20);
        this.writeInt(dataOutput, this.unused21);
        this.writeInt(dataOutput, this.unused22);
        this.writeInt(dataOutput, this.unused23);
        this.writeInt(dataOutput, this.unused24);
        this.writeInt(dataOutput, this.unused25);
        this.writeInt(dataOutput, this.unused26);
        this.writeInt(dataOutput, this.leven);
        this.writeInt(dataOutput, this.lpspol);
        this.writeInt(dataOutput, this.lovrok);
        this.writeInt(dataOutput, this.lcalda);
        this.writeInt(dataOutput, this.unused27);
        dataOutput.writeBytes(SacHeader.trimLen(this.kstnm, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kevnm, 16));
        dataOutput.writeBytes(SacHeader.trimLen(this.khole, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.ko, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.ka, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kt0, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kt1, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kt2, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kt3, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kt4, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kt5, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kt6, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kt7, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kt8, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kt9, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kf, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kuser0, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kuser1, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kuser2, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kcmpnm, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.knetwk, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kdatrd, 8));
        dataOutput.writeBytes(SacHeader.trimLen(this.kinst, 8));
    }

    public final void setLittleEndian() {
        this.byteOrder = false;
    }

    public final void setBigEndian() {
        this.byteOrder = true;
    }

    public static final short swapBytes(short s) {
        return (short)(((s & 0xFF00) >> 8) + ((s & 0xFF) << 8));
    }

    public static final int swapBytes(int n) {
        return ((n & 0xFF000000) >>> 24) + ((n & 0xFF0000) >> 8) + ((n & 0xFF00) << 8) + ((n & 0xFF) << 24);
    }

    public static final long swapBytes(long l) {
        return ((l & 0xFF00000000000000L) >>> 56) + ((l & 0xFF000000000000L) >> 40) + ((l & 0xFF0000000000L) >> 24) + ((l & 0xFF00000000L) >> 8) + ((l & 0xFF000000L) << 8) + ((l & 0xFF0000L) << 24) + ((l & 0xFF00L) << 40) + ((l & 0xFFL) << 56);
    }

    public static String trimLen(String string, int n) {
        if (string.length() > n) {
            string = string.substring(0, n - 1);
        }
        while (string.length() < n) {
            string = string + " ";
        }
        return string;
    }

    public static String format(String string, float f) {
        return SacHeader.format(string, decimalFormat.format(f), 10, 8);
    }

    public static String format(String string, String string2, int n, int n2) {
        while (string.length() < n) {
            string = " " + string;
        }
        while (string2.length() < n2) {
            string2 = " " + string2;
        }
        return string + " = " + string2;
    }

    public static String formatLine(String string, float f, String string2, float f2, String string3, float f3, String string4, float f4, String string5, float f5) {
        return SacHeader.format(string, f) + SacHeader.format(string2, f2) + SacHeader.format(string3, f3) + SacHeader.format(string4, f4) + SacHeader.format(string5, f5);
    }

    public void printHeader() {
        this.printHeader(new PrintWriter(System.out, true));
    }

    public void printHeader(PrintWriter printWriter) {
        printWriter.println(SacHeader.formatLine("delta", this.delta, "depmin", this.depmin, "depmax", this.depmax, "scale", this.scale, "odelta", this.odelta));
        printWriter.println(SacHeader.formatLine("b", this.b, "e", this.e, "o", this.o, "a", this.a, "fmt", this.fmt));
        printWriter.println(SacHeader.formatLine("t0", this.t0, "t1", this.t1, "t2", this.t2, "t3", this.t3, "t4", this.t4));
        printWriter.println(SacHeader.formatLine("t5", this.t5, "t6", this.t6, "t7", this.t7, "t8", this.t8, "t9", this.t9));
        printWriter.println(SacHeader.formatLine("f", this.f, "resp0", this.resp0, "resp1", this.resp1, "resp2", this.resp2, "resp3", this.resp3));
        printWriter.println(SacHeader.formatLine("resp4", this.resp4, "resp5", this.resp5, "resp6", this.resp6, "resp7", this.resp7, "resp8", this.resp8));
        printWriter.println(SacHeader.formatLine("resp9", this.resp9, "stla", this.stla, "stlo", this.stlo, "stel", this.stel, "stdp", this.stdp));
        printWriter.println(SacHeader.formatLine("evla", this.evla, "evlo", this.evlo, "evel", this.evel, "evdp", this.evdp, "mag", this.mag));
        printWriter.println(SacHeader.formatLine("user0", this.user0, "user1", this.user1, "user2", this.user2, "user3", this.user3, "user4", this.user4));
        printWriter.println(SacHeader.formatLine("user5", this.user5, "user6", this.user6, "user7", this.user7, "user8", this.user8, "user9", this.user9));
        printWriter.println(SacHeader.formatLine("dist", this.dist, "az", this.az, "baz", this.baz, "gcarc", this.gcarc, "sb", this.sb));
        printWriter.println(SacHeader.formatLine("sdelta", this.sdelta, "depmen", this.depmen, "cmpaz", this.cmpaz, "cmpinc", this.cmpinc, "xminimum", this.xminimum));
        printWriter.println(SacHeader.formatLine("xmaximum", this.xmaximum, "yminimum", this.yminimum, "ymaximum", this.ymaximum, "unused6", this.unused6, "unused7", this.unused7));
        printWriter.println(SacHeader.formatLine("unused8", this.unused8, "unused9", this.unused9, "unused10", this.unused10, "unused11", this.unused11, "unused12", this.unused12));
        printWriter.println(SacHeader.formatLine("nzyear", this.nzyear, "nzjday", this.nzjday, "nzhour", this.nzhour, "nzmin", this.nzmin, "nzsec", this.nzsec));
        printWriter.println(SacHeader.formatLine("nzmsec", this.nzmsec, "nvhdr", this.nvhdr, "norid", this.norid, "nevid", this.nevid, "npts", this.npts));
        printWriter.println(SacHeader.formatLine("nsnpts", this.nsnpts, "nwfid", this.nwfid, "nxsize", this.nxsize, "nysize", this.nysize, "unused15", this.unused15));
        printWriter.println(SacHeader.formatLine("iftype", this.iftype, "idep", this.idep, "iztype", this.iztype, "unused16", this.unused16, "iinst", this.iinst));
        printWriter.println(SacHeader.formatLine("istreg", this.istreg, "ievreg", this.ievreg, "ievtyp", this.ievtyp, "iqual", this.iqual, "isynth", this.isynth));
        printWriter.println(SacHeader.formatLine("imagtyp", this.imagtyp, "imagsrc", this.imagsrc, "unused19", this.unused19, "unused20", this.unused20, "unused21", this.unused21));
        printWriter.println(SacHeader.formatLine("unused22", this.unused22, "unused23", this.unused23, "unused24", this.unused24, "unused25", this.unused25, "unused26", this.unused26));
        printWriter.println(SacHeader.formatLine("leven", this.leven, "lpspol", this.lpspol, "lovrok", this.lovrok, "lcalda", this.lcalda, "unused27", this.unused27));
        int n = 10;
        int n2 = 31;
        int n3 = 10;
        printWriter.println(SacHeader.format("kstnm", this.kstnm, n, n3) + SacHeader.format("kevnm", this.kevnm, n, n2) + SacHeader.format("khole", this.khole, n + 2, n3));
        printWriter.println(SacHeader.format("ko", this.ko, n, n3) + SacHeader.format("ka = ", this.ka, n, n3) + SacHeader.format("kt0", this.kt0, n, n3) + SacHeader.format("kt1", this.kt1, n, n3));
        printWriter.println(SacHeader.format("kt2", this.kt2, n, n3) + SacHeader.format("kt3 = ", this.kt3, n, n3) + SacHeader.format("kt4", this.kt4, n, n3) + SacHeader.format("kt5", this.kt5, n, n3));
        printWriter.println(SacHeader.format("kt6", this.kt6, n, n3) + SacHeader.format("kt7 = ", this.kt7, n, n3) + SacHeader.format("kt8", this.kt8, n, n3) + SacHeader.format("kt9", this.kt9, n, n3));
        printWriter.println(SacHeader.format("kf", this.kf, n, n3) + SacHeader.format("kuser0 = ", this.kuser0, n, n3) + SacHeader.format("kuser1", this.kuser1, n, n3) + SacHeader.format("kuser2", this.kuser2, n, n3));
        printWriter.println(SacHeader.format("kcmpnm", this.kcmpnm, n, n3) + SacHeader.format("knetwk = ", this.knetwk, n, n3) + SacHeader.format("kdatrd", this.kdatrd, n, n3) + SacHeader.format("kinst", this.kinst, n, n3));
    }

    public boolean getByteOrder() {
        return this.byteOrder;
    }

    public float getDelta() {
        return this.delta;
    }

    public void setDelta(float f) {
        this.delta = f;
    }

    public float getDepmin() {
        return this.depmin;
    }

    public void setDepmin(float f) {
        this.depmin = f;
    }

    public float getDepmax() {
        return this.depmax;
    }

    public void setDepmax(float f) {
        this.depmax = f;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public float getOdelta() {
        return this.odelta;
    }

    public void setOdelta(float f) {
        this.odelta = f;
    }

    public float getB() {
        return this.b;
    }

    public void setB(float f) {
        this.b = f;
    }

    public float getE() {
        return this.e;
    }

    public void setE(float f) {
        this.e = f;
    }

    public float getO() {
        return this.o;
    }

    public void setO(float f) {
        this.o = f;
    }

    public float getA() {
        return this.a;
    }

    public void setA(float f) {
        this.a = f;
    }

    public float getFmt() {
        return this.fmt;
    }

    public void setFmt(float f) {
        this.fmt = f;
    }

    public float getTHeader(int n) {
        switch (n) {
            case 0: {
                return this.getT0();
            }
            case 1: {
                return this.getT1();
            }
            case 2: {
                return this.getT2();
            }
            case 3: {
                return this.getT3();
            }
            case 4: {
                return this.getT4();
            }
            case 5: {
                return this.getT5();
            }
            case 6: {
                return this.getT6();
            }
            case 7: {
                return this.getT7();
            }
            case 8: {
                return this.getT8();
            }
            case 9: {
                return this.getT9();
            }
        }
        throw new IllegalArgumentException("Illegal T header index, " + n + ", must be 0-9");
    }

    public void setTHeader(int n, float f) {
        switch (n) {
            case 0: {
                this.setT0(f);
                break;
            }
            case 1: {
                this.setT1(f);
                break;
            }
            case 2: {
                this.setT2(f);
                break;
            }
            case 3: {
                this.setT3(f);
                break;
            }
            case 4: {
                this.setT4(f);
                break;
            }
            case 5: {
                this.setT5(f);
                break;
            }
            case 6: {
                this.setT6(f);
                break;
            }
            case 7: {
                this.setT7(f);
                break;
            }
            case 8: {
                this.setT8(f);
                break;
            }
            case 9: {
                this.setT9(f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal T header index, " + n + ", must be 0-9");
            }
        }
    }

    public void setTHeader(int n, float f, String string) {
        switch (n) {
            case 0: {
                this.setT0(f);
                this.setKt0(string);
                break;
            }
            case 1: {
                this.setT1(f);
                this.setKt1(string);
                break;
            }
            case 2: {
                this.setT2(f);
                this.setKt2(string);
                break;
            }
            case 3: {
                this.setT3(f);
                this.setKt3(string);
                break;
            }
            case 4: {
                this.setT4(f);
                this.setKt4(string);
                break;
            }
            case 5: {
                this.setT5(f);
                this.setKt5(string);
                break;
            }
            case 6: {
                this.setT6(f);
                this.setKt6(string);
                break;
            }
            case 7: {
                this.setT7(f);
                this.setKt7(string);
                break;
            }
            case 8: {
                this.setT8(f);
                this.setKt8(string);
                break;
            }
            case 9: {
                this.setT9(f);
                this.setKt9(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal T header index, " + n + ", must be 0-9");
            }
        }
    }

    public String getKTHeader(int n) {
        switch (n) {
            case 0: {
                return this.getKt0();
            }
            case 1: {
                return this.getKt1();
            }
            case 2: {
                return this.getKt2();
            }
            case 3: {
                return this.getKt3();
            }
            case 4: {
                return this.getKt4();
            }
            case 5: {
                return this.getKt5();
            }
            case 6: {
                return this.getKt6();
            }
            case 7: {
                return this.getKt7();
            }
            case 8: {
                return this.getKt8();
            }
            case 9: {
                return this.getKt9();
            }
        }
        throw new IllegalArgumentException("Illegal T header index, " + n + ", must be 0-9");
    }

    public void setKtHeader(int n, String string) {
        switch (n) {
            case 0: {
                this.setKt0(string);
                break;
            }
            case 1: {
                this.setKt1(string);
                break;
            }
            case 2: {
                this.setKt2(string);
                break;
            }
            case 3: {
                this.setKt3(string);
                break;
            }
            case 4: {
                this.setKt4(string);
                break;
            }
            case 5: {
                this.setKt5(string);
                break;
            }
            case 6: {
                this.setKt6(string);
                break;
            }
            case 7: {
                this.setKt7(string);
                break;
            }
            case 8: {
                this.setKt8(string);
                break;
            }
            case 9: {
                this.setKt9(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal T header index, " + n + ", must be 0-9");
            }
        }
    }

    public float getT0() {
        return this.t0;
    }

    public void setT0(float f) {
        this.t0 = f;
    }

    public float getT1() {
        return this.t1;
    }

    public void setT1(float f) {
        this.t1 = f;
    }

    public float getT2() {
        return this.t2;
    }

    public void setT2(float f) {
        this.t2 = f;
    }

    public float getT3() {
        return this.t3;
    }

    public void setT3(float f) {
        this.t3 = f;
    }

    public float getT4() {
        return this.t4;
    }

    public void setT4(float f) {
        this.t4 = f;
    }

    public float getT5() {
        return this.t5;
    }

    public void setT5(float f) {
        this.t5 = f;
    }

    public float getT6() {
        return this.t6;
    }

    public void setT6(float f) {
        this.t6 = f;
    }

    public float getT7() {
        return this.t7;
    }

    public void setT7(float f) {
        this.t7 = f;
    }

    public float getT8() {
        return this.t8;
    }

    public void setT8(float f) {
        this.t8 = f;
    }

    public float getT9() {
        return this.t9;
    }

    public void setT9(float f) {
        this.t9 = f;
    }

    public float getF() {
        return this.f;
    }

    public void setF(float f) {
        this.f = f;
    }

    public float getResp0() {
        return this.resp0;
    }

    public void setResp0(float f) {
        this.resp0 = f;
    }

    public float getResp1() {
        return this.resp1;
    }

    public void setResp1(float f) {
        this.resp1 = f;
    }

    public float getResp2() {
        return this.resp2;
    }

    public void setResp2(float f) {
        this.resp2 = f;
    }

    public float getResp3() {
        return this.resp3;
    }

    public void setResp3(float f) {
        this.resp3 = f;
    }

    public float getResp4() {
        return this.resp4;
    }

    public void setResp4(float f) {
        this.resp4 = f;
    }

    public float getResp5() {
        return this.resp5;
    }

    public void setResp5(float f) {
        this.resp5 = f;
    }

    public float getResp6() {
        return this.resp6;
    }

    public void setResp6(float f) {
        this.resp6 = f;
    }

    public float getResp7() {
        return this.resp7;
    }

    public void setResp7(float f) {
        this.resp7 = f;
    }

    public float getResp8() {
        return this.resp8;
    }

    public void setResp8(float f) {
        this.resp8 = f;
    }

    public float getResp9() {
        return this.resp9;
    }

    public void setResp9(float f) {
        this.resp9 = f;
    }

    public float getStla() {
        return this.stla;
    }

    public void setStla(float f) {
        this.stla = f;
    }

    public float getStlo() {
        return this.stlo;
    }

    public void setStlo(float f) {
        this.stlo = f;
    }

    public float getStel() {
        return this.stel;
    }

    public void setStel(float f) {
        this.stel = f;
    }

    public float getStdp() {
        return this.stdp;
    }

    public void setStdp(float f) {
        this.stdp = f;
    }

    public float getEvla() {
        return this.evla;
    }

    public void setEvla(float f) {
        this.evla = f;
    }

    public float getEvlo() {
        return this.evlo;
    }

    public void setEvlo(float f) {
        this.evlo = f;
    }

    public float getEvel() {
        return this.evel;
    }

    public void setEvel(float f) {
        this.evel = f;
    }

    public float getEvdp() {
        return this.evdp;
    }

    public void setEvdp(float f) {
        this.evdp = f;
    }

    public float getMag() {
        return this.mag;
    }

    public void setMag(float f) {
        this.mag = f;
    }

    public float getUserHeader(int n) {
        switch (n) {
            case 0: {
                return this.getUser0();
            }
            case 1: {
                return this.getUser1();
            }
            case 2: {
                return this.getUser2();
            }
            case 3: {
                return this.getUser3();
            }
            case 4: {
                return this.getUser4();
            }
            case 5: {
                return this.getUser5();
            }
            case 6: {
                return this.getUser6();
            }
            case 7: {
                return this.getUser7();
            }
            case 8: {
                return this.getUser8();
            }
            case 9: {
                return this.getUser9();
            }
        }
        throw new IllegalArgumentException("Illegal User header index, " + n + ", must be 0-9");
    }

    public void setUserHeader(int n, float f) {
        switch (n) {
            case 0: {
                this.setUser0(f);
                break;
            }
            case 1: {
                this.setUser1(f);
                break;
            }
            case 2: {
                this.setUser2(f);
                break;
            }
            case 3: {
                this.setUser3(f);
                break;
            }
            case 4: {
                this.setUser4(f);
                break;
            }
            case 5: {
                this.setUser5(f);
                break;
            }
            case 6: {
                this.setUser6(f);
                break;
            }
            case 7: {
                this.setUser7(f);
                break;
            }
            case 8: {
                this.setUser8(f);
                break;
            }
            case 9: {
                this.setUser9(f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal User header index, " + n + ", must be 0-9");
            }
        }
    }

    public float getUser0() {
        return this.user0;
    }

    public void setUser0(float f) {
        this.user0 = f;
    }

    public float getUser1() {
        return this.user1;
    }

    public void setUser1(float f) {
        this.user1 = f;
    }

    public float getUser2() {
        return this.user2;
    }

    public void setUser2(float f) {
        this.user2 = f;
    }

    public float getUser3() {
        return this.user3;
    }

    public void setUser3(float f) {
        this.user3 = f;
    }

    public float getUser4() {
        return this.user4;
    }

    public void setUser4(float f) {
        this.user4 = f;
    }

    public float getUser5() {
        return this.user5;
    }

    public void setUser5(float f) {
        this.user5 = f;
    }

    public float getUser6() {
        return this.user6;
    }

    public void setUser6(float f) {
        this.user6 = f;
    }

    public float getUser7() {
        return this.user7;
    }

    public void setUser7(float f) {
        this.user7 = f;
    }

    public float getUser8() {
        return this.user8;
    }

    public void setUser8(float f) {
        this.user8 = f;
    }

    public float getUser9() {
        return this.user9;
    }

    public void setUser9(float f) {
        this.user9 = f;
    }

    public float getDist() {
        return this.dist;
    }

    public void setDist(float f) {
        this.dist = f;
    }

    public float getAz() {
        return this.az;
    }

    public void setAz(float f) {
        this.az = f;
    }

    public float getBaz() {
        return this.baz;
    }

    public void setBaz(float f) {
        this.baz = f;
    }

    public float getGcarc() {
        return this.gcarc;
    }

    public void setGcarc(float f) {
        this.gcarc = f;
    }

    public float getSb() {
        return this.sb;
    }

    public void setSb(float f) {
        this.sb = f;
    }

    public float getSdelta() {
        return this.sdelta;
    }

    public void setSdelta(float f) {
        this.sdelta = f;
    }

    public float getDepmen() {
        return this.depmen;
    }

    public void setDepmen(float f) {
        this.depmen = f;
    }

    public float getCmpaz() {
        return this.cmpaz;
    }

    public void setCmpaz(float f) {
        this.cmpaz = f;
    }

    public float getCmpinc() {
        return this.cmpinc;
    }

    public void setCmpinc(float f) {
        this.cmpinc = f;
    }

    public float getXminimum() {
        return this.xminimum;
    }

    public void setXminimum(float f) {
        this.xminimum = f;
    }

    public float getXmaximum() {
        return this.xmaximum;
    }

    public void setXmaximum(float f) {
        this.xmaximum = f;
    }

    public float getYminimum() {
        return this.yminimum;
    }

    public void setYminimum(float f) {
        this.yminimum = f;
    }

    public float getYmaximum() {
        return this.ymaximum;
    }

    public void setYmaximum(float f) {
        this.ymaximum = f;
    }

    public float getUnused6() {
        return this.unused6;
    }

    public void setUnused6(float f) {
        this.unused6 = f;
    }

    public float getUnused7() {
        return this.unused7;
    }

    public void setUnused7(float f) {
        this.unused7 = f;
    }

    public float getUnused8() {
        return this.unused8;
    }

    public void setUnused8(float f) {
        this.unused8 = f;
    }

    public float getUnused9() {
        return this.unused9;
    }

    public void setUnused9(float f) {
        this.unused9 = f;
    }

    public float getUnused10() {
        return this.unused10;
    }

    public void setUnused10(float f) {
        this.unused10 = f;
    }

    public float getUnused11() {
        return this.unused11;
    }

    public void setUnused11(float f) {
        this.unused11 = f;
    }

    public float getUnused12() {
        return this.unused12;
    }

    public void setUnused12(float f) {
        this.unused12 = f;
    }

    public int getNzyear() {
        return this.nzyear;
    }

    public void setNzyear(int n) {
        this.nzyear = n;
    }

    public int getNzjday() {
        return this.nzjday;
    }

    public void setNzjday(int n) {
        this.nzjday = n;
    }

    public int getNzhour() {
        return this.nzhour;
    }

    public void setNzhour(int n) {
        this.nzhour = n;
    }

    public int getNzmin() {
        return this.nzmin;
    }

    public void setNzmin(int n) {
        this.nzmin = n;
    }

    public int getNzsec() {
        return this.nzsec;
    }

    public void setNzsec(int n) {
        this.nzsec = n;
    }

    public int getNzmsec() {
        return this.nzmsec;
    }

    public void setNzmsec(int n) {
        this.nzmsec = n;
    }

    public int getNvhdr() {
        return this.nvhdr;
    }

    public void setNvhdr(int n) {
        this.nvhdr = n;
    }

    public int getNorid() {
        return this.norid;
    }

    public void setNorid(int n) {
        this.norid = n;
    }

    public int getNevid() {
        return this.nevid;
    }

    public void setNevid(int n) {
        this.nevid = n;
    }

    public int getNpts() {
        return this.npts;
    }

    public void setNpts(int n) {
        this.npts = n;
    }

    public int getNsnpts() {
        return this.nsnpts;
    }

    public void setNsnpts(int n) {
        this.nsnpts = n;
    }

    public int getNwfid() {
        return this.nwfid;
    }

    public void setNwfid(int n) {
        this.nwfid = n;
    }

    public int getNxsize() {
        return this.nxsize;
    }

    public void setNxsize(int n) {
        this.nxsize = n;
    }

    public int getNysize() {
        return this.nysize;
    }

    public void setNysize(int n) {
        this.nysize = n;
    }

    public int getUnused15() {
        return this.unused15;
    }

    public void setUnused15(int n) {
        this.unused15 = n;
    }

    public int getIftype() {
        return this.iftype;
    }

    public void setIftype(int n) {
        this.iftype = n;
    }

    public int getIdep() {
        return this.idep;
    }

    public void setIdep(int n) {
        this.idep = n;
    }

    public int getIztype() {
        return this.iztype;
    }

    public void setIztype(int n) {
        this.iztype = n;
    }

    public int getUnused16() {
        return this.unused16;
    }

    public void setUnused16(int n) {
        this.unused16 = n;
    }

    public int getIinst() {
        return this.iinst;
    }

    public void setIinst(int n) {
        this.iinst = n;
    }

    public int getIstreg() {
        return this.istreg;
    }

    public void setIstreg(int n) {
        this.istreg = n;
    }

    public int getIevreg() {
        return this.ievreg;
    }

    public void setIevreg(int n) {
        this.ievreg = n;
    }

    public int getIevtyp() {
        return this.ievtyp;
    }

    public void setIevtyp(int n) {
        this.ievtyp = n;
    }

    public int getIqual() {
        return this.iqual;
    }

    public void setIqual(int n) {
        this.iqual = n;
    }

    public int getIsynth() {
        return this.isynth;
    }

    public void setIsynth(int n) {
        this.isynth = n;
    }

    public int getImagtyp() {
        return this.imagtyp;
    }

    public void setImagtyp(int n) {
        this.imagtyp = n;
    }

    public int getImagsrc() {
        return this.imagsrc;
    }

    public void setImagsrc(int n) {
        this.imagsrc = n;
    }

    public int getUnused19() {
        return this.unused19;
    }

    public void setUnused19(int n) {
        this.unused19 = n;
    }

    public int getUnused20() {
        return this.unused20;
    }

    public void setUnused20(int n) {
        this.unused20 = n;
    }

    public int getUnused21() {
        return this.unused21;
    }

    public void setUnused21(int n) {
        this.unused21 = n;
    }

    public int getUnused22() {
        return this.unused22;
    }

    public void setUnused22(int n) {
        this.unused22 = n;
    }

    public int getUnused23() {
        return this.unused23;
    }

    public void setUnused23(int n) {
        this.unused23 = n;
    }

    public int getUnused24() {
        return this.unused24;
    }

    public void setUnused24(int n) {
        this.unused24 = n;
    }

    public int getUnused25() {
        return this.unused25;
    }

    public void setUnused25(int n) {
        this.unused25 = n;
    }

    public int getUnused26() {
        return this.unused26;
    }

    public void setUnused26(int n) {
        this.unused26 = n;
    }

    public int getLeven() {
        return this.leven;
    }

    public void setLeven(int n) {
        this.leven = n;
    }

    public int getLpspol() {
        return this.lpspol;
    }

    public void setLpspol(int n) {
        this.lpspol = n;
    }

    public int getLovrok() {
        return this.lovrok;
    }

    public void setLovrok(int n) {
        this.lovrok = n;
    }

    public int getLcalda() {
        return this.lcalda;
    }

    public void setLcalda(int n) {
        this.lcalda = n;
    }

    public int getUnused27() {
        return this.unused27;
    }

    public void setUnused27(int n) {
        this.unused27 = n;
    }

    public String getKstnm() {
        return this.kstnm;
    }

    public void setKstnm(String string) {
        this.kstnm = string;
    }

    public String getKevnm() {
        return this.kevnm;
    }

    public void setKevnm(String string) {
        this.kevnm = string;
    }

    public String getKhole() {
        return this.khole;
    }

    public void setKhole(String string) {
        this.khole = string;
    }

    public String getKo() {
        return this.ko;
    }

    public void setKo(String string) {
        this.ko = string;
    }

    public String getKa() {
        return this.ka;
    }

    public void setKa(String string) {
        this.ka = string;
    }

    public String getKt0() {
        return this.kt0;
    }

    public void setKt0(String string) {
        this.kt0 = string;
    }

    public String getKt1() {
        return this.kt1;
    }

    public void setKt1(String string) {
        this.kt1 = string;
    }

    public String getKt2() {
        return this.kt2;
    }

    public void setKt2(String string) {
        this.kt2 = string;
    }

    public String getKt3() {
        return this.kt3;
    }

    public void setKt3(String string) {
        this.kt3 = string;
    }

    public String getKt4() {
        return this.kt4;
    }

    public void setKt4(String string) {
        this.kt4 = string;
    }

    public String getKt5() {
        return this.kt5;
    }

    public void setKt5(String string) {
        this.kt5 = string;
    }

    public String getKt6() {
        return this.kt6;
    }

    public void setKt6(String string) {
        this.kt6 = string;
    }

    public String getKt7() {
        return this.kt7;
    }

    public void setKt7(String string) {
        this.kt7 = string;
    }

    public String getKt8() {
        return this.kt8;
    }

    public void setKt8(String string) {
        this.kt8 = string;
    }

    public String getKt9() {
        return this.kt9;
    }

    public void setKt9(String string) {
        this.kt9 = string;
    }

    public String getKf() {
        return this.kf;
    }

    public void setKf(String string) {
        this.kf = string;
    }

    public String getKuser0() {
        return this.kuser0;
    }

    public void setKuser0(String string) {
        this.kuser0 = string;
    }

    public String getKuser1() {
        return this.kuser1;
    }

    public void setKuser1(String string) {
        this.kuser1 = string;
    }

    public String getKuser2() {
        return this.kuser2;
    }

    public void setKuser2(String string) {
        this.kuser2 = string;
    }

    public String getKcmpnm() {
        return this.kcmpnm;
    }

    public void setKcmpnm(String string) {
        this.kcmpnm = string;
    }

    public String getKnetwk() {
        return this.knetwk;
    }

    public void setKnetwk(String string) {
        this.knetwk = string;
    }

    public String getKdatrd() {
        return this.kdatrd;
    }

    public void setKdatrd(String string) {
        this.kdatrd = string;
    }

    public String getKinst() {
        return this.kinst;
    }

    public void setKinst(String string) {
        this.kinst = string;
    }

    public void setByteOrder(boolean bl) {
        this.byteOrder = bl;
    }
}

