/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

public class Complex {
    protected double real;
    protected double imaginary;

    public Complex(double d, double d2) {
        this.real = d;
        this.imaginary = d2;
    }

    public double getReal() {
        return this.real;
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public final double mag() {
        return Math.sqrt(this.getReal() * this.getReal() + this.getImaginary() * this.getImaginary());
    }

    public final Complex conjg() {
        return new Complex(this.getReal(), -1.0 * this.getImaginary());
    }

    public static final Complex add(double d, Complex complex) {
        return Complex.add(new Complex(d, 0.0), complex);
    }

    public static final Complex add(Complex complex, double d) {
        return Complex.add(complex, new Complex(d, 0.0));
    }

    public static final Complex add(Complex complex, Complex complex2) {
        return new Complex(complex.getReal() + complex2.getReal(), complex.getImaginary() + complex2.getImaginary());
    }

    public static final Complex sub(double d, Complex complex) {
        return Complex.sub(new Complex(d, 0.0), complex);
    }

    public static final Complex sub(Complex complex, double d) {
        return Complex.sub(complex, new Complex(d, 0.0));
    }

    public static final Complex sub(Complex complex, Complex complex2) {
        return new Complex(complex.getReal() - complex2.getReal(), complex.getImaginary() - complex2.getImaginary());
    }

    public static final Complex mul(double d, Complex complex) {
        return Complex.mul(new Complex(d, 0.0), complex);
    }

    public static final Complex mul(Complex complex, double d) {
        return Complex.mul(complex, new Complex(d, 0.0));
    }

    public static final Complex mul(Complex complex, Complex complex2) {
        return new Complex(complex.getReal() * complex2.getReal() - complex.getImaginary() * complex2.getImaginary(), complex.getImaginary() * complex2.getReal() + complex.getReal() * complex2.getImaginary());
    }

    public static final Complex div(double d, Complex complex) {
        return Complex.div(new Complex(d, 0.0), complex);
    }

    public static final Complex div(Complex complex, double d) {
        return Complex.div(complex, new Complex(d, 0.0));
    }

    public static final Complex div(Complex complex, Complex complex2) {
        if (Math.abs(complex2.getReal()) >= Math.abs(complex2.getImaginary())) {
            double d = complex2.getImaginary() / complex2.getReal();
            double d2 = complex2.getReal() + d * complex2.getImaginary();
            return new Complex((complex.getReal() + d * complex.getImaginary()) / d2, (complex.getImaginary() - d * complex.getReal()) / d2);
        }
        double d = complex2.getReal() / complex2.getImaginary();
        double d3 = complex2.getImaginary() + d * complex2.getReal();
        return new Complex((complex.getReal() * d + complex.getImaginary()) / d3, (complex.getImaginary() * d - complex.getReal()) / d3);
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            return this.getReal() == complex.getReal() && this.getImaginary() == complex.getImaginary();
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        long l = Double.doubleToLongBits(this.getImaginary());
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.getReal());
        n = 37 * n + (int)(l ^ l >>> 32);
        return n;
    }
}

