/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.psn.PSNDataFile;
import edu.sc.seis.seisFile.psn.PSNEventInfo;
import edu.sc.seis.seisFile.psn.PSNPhasePick;
import edu.sc.seis.seisFile.psn.PSNPolesAndZeros;
import edu.sc.seis.seisFile.psn.PSNSensorAmpAtoD;
import edu.sc.seis.seisFile.sac.SacHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PSNVariableHeader {
    private DataInputStream dis;
    private Map entries = new HashMap();

    public PSNVariableHeader(DataInputStream dataInputStream, int n) throws IOException {
        this.dis = dataInputStream;
        for (int i = 0; i < n; ++i) {
            byte by = this.dis.readByte();
            if (by != 85) {
                throw new IOException("file may not be a standard Type 4 PSN format");
            }
            byte by2 = this.dis.readByte();
            int n2 = SacHeader.swapBytes(this.dis.readInt());
            switch (by2) {
                case 0: {
                    if (n2 == 0) break;
                    throw new IOException("end of header has unread data");
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    byte[] byArray = new byte[n2];
                    this.dis.readFully(byArray);
                    String string = new String(PSNDataFile.chopToLength(byArray));
                    this.entries.put(new Byte(by2), string);
                    break;
                }
                case 4: {
                    ArrayList arrayList = this.entries.containsKey(new Byte(by2)) ? (ArrayList)this.entries.get(new Byte(by2)) : new ArrayList();
                    arrayList.add(new PSNEventInfo(this.dis));
                    this.entries.put(new Byte(by2), arrayList);
                    break;
                }
                case 5: {
                    ArrayList arrayList = this.hasPhasePicks() ? (ArrayList)this.entries.get(new Byte(by2)) : new ArrayList();
                    arrayList.add(new PSNPhasePick(this.dis));
                    this.entries.put(new Byte(by2), arrayList);
                    break;
                }
                case 11: {
                    this.entries.put(new Byte(by2), new PSNSensorAmpAtoD(this.dis));
                    break;
                }
                case 12: {
                    this.entries.put(new Byte(by2), new PSNPolesAndZeros(this.dis));
                    break;
                }
                default: {
                    this.dis.skip(n2);
                }
            }
            i += n2 + 5;
        }
    }

    public boolean hasSensorLocation() {
        return this.entries.containsKey(new Byte(1));
    }

    public String getSensorLocation() {
        return (String)this.entries.get(new Byte(1));
    }

    public boolean hasSensorInformation() {
        return this.entries.containsKey(new Byte(2));
    }

    public String getSensorInformation() {
        return (String)this.entries.get(new Byte(2));
    }

    public boolean hasComment() {
        return this.entries.containsKey(new Byte(3));
    }

    public String getComment() {
        return (String)this.entries.get(new Byte(3));
    }

    public boolean hasEventInfo() {
        return this.entries.containsKey(new Byte(4));
    }

    public PSNEventInfo[] getEventInfo() {
        ArrayList arrayList = (ArrayList)this.entries.get(new Byte(4));
        return arrayList.toArray(new PSNEventInfo[0]);
    }

    public boolean hasPhasePicks() {
        return this.entries.containsKey(new Byte(5));
    }

    public PSNPhasePick[] getPhasePicks() {
        ArrayList arrayList = (ArrayList)this.entries.get(new Byte(5));
        return arrayList.toArray(new PSNPhasePick[0]);
    }

    public boolean hasDataLoggerID() {
        return this.entries.containsKey(new Byte(7));
    }

    public String getDataLoggerID() {
        return (String)this.entries.get(new Byte(7));
    }

    public boolean hasSensorAmpAtoD() {
        return this.entries.containsKey(new Byte(11));
    }

    public PSNSensorAmpAtoD getSensorAmpAtoD() {
        return (PSNSensorAmpAtoD)this.entries.get(new Byte(11));
    }

    public boolean hasPolesAndZeros() {
        return this.entries.containsKey(new Byte(12));
    }

    public PSNPolesAndZeros getPolesAndZeros() {
        return (PSNPolesAndZeros)this.entries.get(new Byte(12));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.entries.keySet();
        for (Byte by : set) {
            byte by2 = by;
            switch (by2) {
                case 1: {
                    stringBuffer.append("Sensor Location: " + (String)this.entries.get(by) + '\n');
                    break;
                }
                case 2: {
                    stringBuffer.append("Sensor Info: " + (String)this.entries.get(by) + '\n');
                    break;
                }
                case 3: {
                    stringBuffer.append("Comments: " + (String)this.entries.get(by) + '\n');
                    break;
                }
                case 7: {
                    stringBuffer.append("DataLogger ID: " + (String)this.entries.get(by) + '\n');
                    break;
                }
                case 4: {
                    ArrayList arrayList = (ArrayList)this.entries.get(by);
                    for (Object object2 : arrayList) {
                        stringBuffer.append(((PSNEventInfo)object2).toString());
                    }
                    break;
                }
                case 5: {
                    Object object;
                    Object object2;
                    object2 = (ArrayList)this.entries.get(by);
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = (PSNEventInfo)iterator.next();
                        stringBuffer.append(((PSNEventInfo)object).toString());
                    }
                    break;
                }
                case 11: {
                    Object object = (PSNSensorAmpAtoD)this.entries.get(by);
                    stringBuffer.append(object.toString());
                    break;
                }
                case 12: {
                    PSNPolesAndZeros pSNPolesAndZeros = (PSNPolesAndZeros)this.entries.get(by);
                    stringBuffer.append(pSNPolesAndZeros.toString());
                }
            }
        }
        return stringBuffer.toString();
    }
}

