/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.sac.SacHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class PSNPolesAndZeros {
    private DataInputStream dis;
    short numZeros;
    short numPoles;
    double[][] zeros;
    double[][] poles;

    public PSNPolesAndZeros(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        this.dis = dataInputStream;
        this.numZeros = SacHeader.swapBytes(this.dis.readShort());
        this.numPoles = SacHeader.swapBytes(this.dis.readShort());
        this.zeros = new double[this.numZeros][2];
        for (n2 = 0; n2 < this.numZeros; ++n2) {
            for (n = 0; n < 2; ++n) {
                this.zeros[n2][n] = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
            }
        }
        this.poles = new double[this.numPoles][2];
        for (n2 = 0; n2 < this.numZeros; ++n2) {
            for (n = 0; n < 2; ++n) {
                this.poles[n2][n] = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
            }
        }
    }

    public short getNumZeros() {
        return this.numZeros;
    }

    public short getNumPoles() {
        return this.numPoles;
    }

    public double[][] getZeros() {
        return this.zeros;
    }

    public double[][] getPoles() {
        return this.poles;
    }
}

