/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.psn.PSNDataFile;
import edu.sc.seis.seisFile.psn.PSNDateTime;
import edu.sc.seis.seisFile.sac.SacHeader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class PSNHeader {
    private DataInputStream dis;
    private byte[] eightBytes = new byte[8];
    private byte[] sixBytes = new byte[6];
    private byte[] fourBytes = new byte[4];
    private byte[] threeBytes = new byte[3];
    private byte[] twoBytes = new byte[2];
    private boolean isVolume = false;
    private int numRecords;
    private int varHeadLength;
    private PSNDateTime dateTime;
    private double startTimeOffset;
    private double sampleRate;
    private int sampleCount;
    private int flags;
    private String timeRefType;
    private byte timeRefStatus;
    private byte sampleDataType;
    private byte sampleCompression;
    private double compIncident;
    private double compAz;
    private byte compOrientation;
    private byte sensorType;
    private double sensorLat;
    private double sensorLong;
    private double sensorElevation;
    private String sensorName;
    private String channelId;
    private String sensorNetwork;
    private double sensitivity;
    private double magCorrect;
    private short adBitRes;
    private double sampleMin;
    private double sampleMax;
    private double sampleMean;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PSNHeader(DataInputStream dataInputStream) throws IOException, FileNotFoundException {
        this.dis = dataInputStream;
        this.dis.readFully(this.eightBytes);
        String string = new String(this.eightBytes);
        if (string.equals("PSNVOLUM")) {
            this.dis.readFully(this.twoBytes);
            if (!new String(this.twoBytes).equals("E1")) throw new FileNotFoundException("File is not of type PSNVOLUME1");
            this.isVolume = true;
            this.numRecords = SacHeader.swapBytes(this.dis.readShort());
        } else if (!string.equals("PSNTYPE4")) {
            throw new FileNotFoundException("File is not of type PSNTYPE4: " + string);
        }
        if (this.isVolume) return;
        this.numRecords = 1;
        this.readHeader();
    }

    public boolean isVolumeFile() {
        return this.isVolume;
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    private void readHeader() throws IOException {
        this.varHeadLength = SacHeader.swapBytes(this.dis.readInt());
        this.dateTime = new PSNDateTime(this.dis);
        this.startTimeOffset = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.sampleRate = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.sampleCount = SacHeader.swapBytes(this.dis.readInt());
        this.flags = SacHeader.swapBytes(this.dis.readInt());
        this.dis.readFully(this.threeBytes);
        this.timeRefType = new String(PSNDataFile.chopToLength(this.threeBytes));
        this.timeRefStatus = this.dis.readByte();
        this.sampleDataType = this.dis.readByte();
        this.sampleCompression = this.dis.readByte();
        this.compIncident = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.compAz = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.compOrientation = this.dis.readByte();
        this.sensorType = this.dis.readByte();
        this.sensorLat = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.sensorLong = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.sensorElevation = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.dis.readFully(this.sixBytes);
        this.sensorName = new String(PSNDataFile.chopToLength(this.sixBytes));
        this.dis.readFully(this.fourBytes);
        this.channelId = new String(PSNDataFile.chopToLength(this.fourBytes));
        this.dis.readFully(this.sixBytes);
        this.sensorNetwork = new String(PSNDataFile.chopToLength(this.sixBytes));
        this.sensitivity = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.magCorrect = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.adBitRes = SacHeader.swapBytes(this.dis.readShort());
        this.sampleMin = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.sampleMax = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.sampleMean = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
    }

    public int getVarHeadLength() {
        return this.varHeadLength;
    }

    public PSNDateTime getDateTime() {
        return this.dateTime;
    }

    public double getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getTimeRefType() {
        return this.timeRefType;
    }

    public byte getTimeRefStatus() {
        return this.timeRefStatus;
    }

    public byte getSampleDataType() {
        return this.sampleDataType;
    }

    public byte getSampleCompression() {
        return this.sampleCompression;
    }

    public double getCompIncident() {
        return this.compIncident;
    }

    public double getCompAz() {
        return this.compAz;
    }

    public byte getCompOrientation() {
        return this.compOrientation;
    }

    public byte getSensorType() {
        return this.sensorType;
    }

    public double getSensorLat() {
        return this.sensorLat;
    }

    public double getSensorLong() {
        return this.sensorLong;
    }

    public double getSensorElevation() {
        return this.sensorElevation;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getSensorNetwork() {
        return this.sensorNetwork;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public double getMagCorrect() {
        return this.magCorrect;
    }

    public short getAdBitRes() {
        return this.adBitRes;
    }

    public double getSampleMin() {
        return this.sampleMin;
    }

    public double getSampleMax() {
        return this.sampleMax;
    }

    public double getSampleMean() {
        return this.sampleMean;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Variable Header length: " + this.getVarHeadLength() + '\n');
        stringBuffer.append("Date: " + this.dateTime.toString() + '\n');
        stringBuffer.append("Start Time Offset: " + this.getStartTimeOffset() + '\n');
        stringBuffer.append("Samle Rate: " + this.getSampleRate() + '\n');
        stringBuffer.append("Sample Count: " + this.getSampleCount() + '\n');
        stringBuffer.append("Flags: " + this.getFlags() + '\n');
        stringBuffer.append("Timing Ref Type: " + this.getTimeRefType() + '\n');
        stringBuffer.append("Timing Ref Status: " + this.getTimeRefStatus() + '\n');
        stringBuffer.append("Sample Data Type: " + this.getSampleDataType() + '\n');
        stringBuffer.append("Sample Compression: " + this.getSampleCompression() + '\n');
        stringBuffer.append("Component Incident: " + this.getCompIncident() + '\n');
        stringBuffer.append("Component Azimuth: " + this.getCompAz() + '\n');
        stringBuffer.append("Component Orientation: " + this.getCompOrientation() + '\n');
        stringBuffer.append("Sensor Type: " + this.getSensorType() + '\n');
        stringBuffer.append("Sensor Lat/Lon: " + this.getSensorLat() + " " + this.getSensorLong() + '\n');
        stringBuffer.append("Sensor Elevation: " + this.getSensorElevation() + '\n');
        stringBuffer.append("Sensor Name: " + this.getSensorName() + '\n');
        stringBuffer.append("Channel ID: " + this.getChannelId() + '\n');
        stringBuffer.append("Network: " + this.getSensorNetwork() + '\n');
        stringBuffer.append("Sensitivity: " + this.getSensitivity() + '\n');
        stringBuffer.append("Magnitude Correction: " + this.getMagCorrect() + '\n');
        stringBuffer.append("A/D bit Resolution: " + this.getAdBitRes() + '\n');
        double d = this.getSampleMin();
        double d2 = this.getSampleMax();
        double d3 = this.getSampleMean();
        stringBuffer.append("Min/Max/Mean: " + d + " " + d2 + " " + d3 + '\n');
        return stringBuffer.toString();
    }
}

