/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.psn.PSNHeader;
import edu.sc.seis.seisFile.psn.PSNVariableHeader;
import edu.sc.seis.seisFile.sac.SacHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class PSNEventRecord {
    private DataInputStream dis;
    private PSNHeader fixedHeader;
    private PSNVariableHeader varHeader;
    private boolean isShort = false;
    private boolean isInt = false;
    private boolean isFloat = false;
    private boolean isDouble = false;
    private short[] samplesShort;
    private int[] samplesInt;
    private float[] samplesFloat;
    private double[] samplesDouble;

    public PSNEventRecord(DataInputStream dataInputStream) throws IOException {
        this(new PSNHeader(dataInputStream), dataInputStream);
    }

    public PSNEventRecord(PSNHeader pSNHeader, DataInputStream dataInputStream) throws IOException {
        this.dis = dataInputStream;
        this.fixedHeader = pSNHeader;
        this.varHeader = new PSNVariableHeader(this.dis, pSNHeader.getVarHeadLength());
        this.readSampleData();
        if (this.fixedHeader.getFlags() == 1) {
            if (this.dis.readShort() != 0) {
                throw new IOException("CRC-16 check has wrong value!");
            }
        } else {
            this.dis.skipBytes(2);
        }
    }

    private void readSampleData() throws IOException {
        byte by = this.fixedHeader.getSampleDataType();
        switch (by) {
            case 0: {
                this.isShort = true;
                this.samplesShort = new short[this.fixedHeader.getSampleCount()];
                for (int i = 0; i < this.samplesShort.length; ++i) {
                    this.samplesShort[i] = SacHeader.swapBytes(this.dis.readShort());
                }
                break;
            }
            case 1: {
                this.isInt = true;
                this.samplesInt = new int[this.fixedHeader.getSampleCount()];
                for (int i = 0; i < this.samplesInt.length; ++i) {
                    this.samplesInt[i] = SacHeader.swapBytes(this.dis.readInt());
                }
                break;
            }
            case 2: {
                this.isFloat = true;
                this.samplesFloat = new float[this.fixedHeader.getSampleCount()];
                for (int i = 0; i < this.samplesFloat.length; ++i) {
                    this.samplesFloat[i] = Float.intBitsToFloat(SacHeader.swapBytes(this.dis.readInt()));
                }
                break;
            }
            case 3: {
                this.isDouble = true;
                this.samplesDouble = new double[this.fixedHeader.getSampleCount()];
                for (int i = 0; i < this.samplesDouble.length; ++i) {
                    this.samplesDouble[i] = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
                }
                break;
            }
            default: {
                throw new IOException("data type not supported");
            }
        }
    }

    public PSNHeader getFixedHeader() {
        return this.fixedHeader;
    }

    public PSNVariableHeader getVariableHeader() {
        return this.varHeader;
    }

    public boolean isSampleDataShort() {
        return this.isShort;
    }

    public short[] getSampleDataShort() {
        return this.samplesShort;
    }

    public boolean isSampleDataInt() {
        return this.isInt;
    }

    public int[] getSampleDataInt() {
        return this.samplesInt;
    }

    public boolean isSampleDataFloat() {
        return this.isFloat;
    }

    public float[] getSampleDataFloat() {
        return this.samplesFloat;
    }

    public boolean isSampleDataDouble() {
        return this.isDouble;
    }

    public double[] getSampleDataDouble() {
        return this.samplesDouble;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fixedHeader.toString());
        stringBuffer.append(this.varHeader.toString());
        if (this.isShort) {
            for (n = 0; n < this.samplesShort.length; ++n) {
                stringBuffer.append(this.samplesShort[n] + " ");
            }
        }
        if (this.isInt) {
            for (n = 0; n < this.samplesInt.length; ++n) {
                stringBuffer.append(this.samplesInt[n] + " ");
            }
        }
        if (this.isFloat) {
            for (n = 0; n < this.samplesFloat.length; ++n) {
                stringBuffer.append(this.samplesFloat[n] + " ");
            }
        }
        if (this.isDouble) {
            for (n = 0; n < this.samplesDouble.length; ++n) {
                stringBuffer.append(this.samplesDouble[n] + " ");
            }
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

