/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.psn.PSNDataFile;
import edu.sc.seis.seisFile.psn.PSNDateTime;
import edu.sc.seis.seisFile.sac.SacHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class PSNEventInfo {
    private DataInputStream dis;
    private byte[] fourBytes = new byte[4];
    private byte[] sixBytes = new byte[6];
    private PSNDateTime time;
    private double lat;
    private double lon;
    private double depthKM;
    private double[] magnitudes;
    private String otherMagType;
    private byte eventType;
    private byte locationQuality;
    private short flags;
    private String reportingAgency;

    public PSNEventInfo(DataInputStream dataInputStream) throws IOException {
        this.dis = dataInputStream;
        this.time = new PSNDateTime(this.dis);
        this.lat = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.lon = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.depthKM = Double.longBitsToDouble(SacHeader.swapBytes(this.dis.readLong()));
        this.magnitudes = new double[6];
        for (int i = 0; i < this.magnitudes.length; ++i) {
            this.magnitudes[i] = (double)SacHeader.swapBytes(this.dis.readShort()) / 100.0;
        }
        this.dis.readFully(this.fourBytes);
        this.otherMagType = new String(PSNDataFile.chopToLength(this.fourBytes));
        this.eventType = this.dis.readByte();
        this.locationQuality = this.dis.readByte();
        this.flags = SacHeader.swapBytes((short)this.dis.readUnsignedShort());
        this.dis.readFully(this.sixBytes);
        this.reportingAgency = new String(PSNDataFile.chopToLength(this.sixBytes));
    }

    public PSNDateTime getTime() {
        return this.time;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getDepthKM() {
        return this.depthKM;
    }

    public double[] getMagnitudes() {
        return this.magnitudes;
    }

    public String getOtherMagType() {
        return this.otherMagType;
    }

    public byte getEventType() {
        return this.eventType;
    }

    public byte getLocationQuality() {
        return this.locationQuality;
    }

    public short getFlags() {
        return this.flags;
    }

    public String getReportingAgency() {
        return this.reportingAgency;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Time: " + this.time.toString() + '\n');
        stringBuffer.append("Location: Lat " + this.lat + ", Lon " + this.lon + ", Depth " + this.depthKM + '\n');
        stringBuffer.append("Magnitudes: ");
        for (int i = 0; i < this.magnitudes.length; ++i) {
            stringBuffer.append(this.magnitudes[i] + " ");
        }
        stringBuffer.append('\n');
        stringBuffer.append("Other Mag type: " + this.otherMagType + '\n');
        stringBuffer.append("Event Type Code: " + this.eventType + '\n');
        stringBuffer.append("Event Location Quarlity: " + this.locationQuality + '\n');
        stringBuffer.append("Flags: " + this.flags + '\n');
        stringBuffer.append("Reporting Agency: " + this.reportingAgency + '\n');
        return stringBuffer.toString();
    }
}

