/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.sac.SacHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class PSNDateTime {
    private DataInputStream dis;
    private short year;
    private byte month;
    private byte day;
    private byte hour;
    private byte minute;
    private byte second;
    private int nanosec;

    public PSNDateTime(DataInputStream dataInputStream) throws IOException {
        this.dis = dataInputStream;
        this.year = SacHeader.swapBytes((short)this.dis.readUnsignedShort());
        this.month = this.dis.readByte();
        this.day = this.dis.readByte();
        this.hour = this.dis.readByte();
        this.minute = this.dis.readByte();
        this.second = this.dis.readByte();
        this.dis.readByte();
        this.nanosec = SacHeader.swapBytes(this.dis.readInt());
    }

    public PSNDateTime(short s, byte by, byte by2, byte by3, byte by4, byte by5, int n) {
        this.year = s;
        this.month = by;
        this.day = by2;
        this.hour = by3;
        this.minute = by4;
        this.second = by5;
        this.nanosec = n;
    }

    public short getYear() {
        return this.year;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getDay() {
        return this.day;
    }

    public byte getHour() {
        return this.hour;
    }

    public byte getMinute() {
        return this.minute;
    }

    public byte getSecond() {
        return this.second;
    }

    public int getNanosec() {
        return this.nanosec;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.month + "/" + this.day + "/" + this.year + " " + this.hour + ":" + this.minute + ":" + this.second + ":" + this.nanosec);
        return stringBuffer.toString();
    }
}

