/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.psn.PSNEventRecord;
import edu.sc.seis.seisFile.psn.PSNHeader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class PSNDataFile {
    private PSNEventRecord[] eventRecs;

    public PSNDataFile(String string) throws FileNotFoundException, IOException {
        this(new DataInputStream(new BufferedInputStream(new FileInputStream(string))));
    }

    public PSNDataFile(DataInputStream dataInputStream) throws FileNotFoundException, IOException {
        this.readFile(dataInputStream);
        dataInputStream.close();
    }

    private void readFile(DataInputStream dataInputStream) throws IOException, FileNotFoundException {
        PSNHeader pSNHeader = new PSNHeader(dataInputStream);
        if (!pSNHeader.isVolumeFile()) {
            this.eventRecs = new PSNEventRecord[]{new PSNEventRecord(pSNHeader, dataInputStream)};
        } else {
            this.eventRecs = new PSNEventRecord[pSNHeader.getNumRecords()];
            for (int i = 0; i < pSNHeader.getNumRecords(); ++i) {
                this.eventRecs[i] = new PSNEventRecord(dataInputStream);
            }
        }
    }

    public PSNEventRecord[] getEventRecords() {
        return this.eventRecs;
    }

    public static byte[] chopToLength(byte[] byArray) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            arrayList.add(new Byte(byArray[i]));
        }
        byte[] byArray2 = new byte[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            byArray2[i] = (Byte)arrayList.get(i);
        }
        return byArray2;
    }

    public static void main(String[] stringArray) {
        try {
            PSNDataFile pSNDataFile = new PSNDataFile(stringArray[0]);
            PSNEventRecord[] pSNEventRecordArray = pSNDataFile.getEventRecords();
            System.out.println("Number of Records: " + pSNEventRecordArray.length);
            for (int i = 0; i < pSNEventRecordArray.length; ++i) {
                System.out.println("****** Event Record " + i + " ******");
                System.out.println(pSNEventRecordArray[i].toString());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

