/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.DataRecordBeginComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Utility {
    public static int extractInteger(byte[] byArray, int n, int n2) {
        return Integer.parseInt(Utility.extractString(byArray, n, n2));
    }

    public static String extractString(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new String(byArray2);
    }

    public static String extractVarString(byte[] byArray, int n, int n2) {
        return Utility.extractTermString(byArray, n, n2, (byte)126);
    }

    public static String extractNullTermString(byte[] byArray, int n, int n2) {
        return Utility.extractTermString(byArray, n, n2, (byte)0);
    }

    static String extractTermString(byte[] byArray, int n, int n2, byte by) {
        int n3;
        for (n3 = 0; n3 < n2 && n + n3 < byArray.length && byArray[n + n3] != by; ++n3) {
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        return new String(byArray2);
    }

    public static short bytesToShort(byte by, byte by2, boolean bl) {
        if (bl) {
            return (short)((by & 0xFF) + ((by2 & 0xFF) << 8));
        }
        return (short)(((by & 0xFF) << 8) + (by2 & 0xFF));
    }

    public static int bytesToInt(byte by) {
        return by;
    }

    public static int uBytesToInt(byte by) {
        return by & 0xFF;
    }

    public static int bytesToInt(byte[] byArray, int n, boolean bl) {
        return Utility.bytesToInt(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3], bl);
    }

    public static long bytesToLong(byte[] byArray, int n, boolean bl) {
        return Utility.bytesToLong(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3], byArray[n + 4], byArray[n + 5], byArray[n + 6], byArray[n + 7], bl);
    }

    public static int bytesToInt(byte by, byte by2, boolean bl) {
        if (bl) {
            return (by & 0xFF) + (by2 << 8);
        }
        return (by << 8) + (by2 & 0xFF);
    }

    public static int uBytesToInt(byte by, byte by2, boolean bl) {
        if (bl) {
            return (by & 0xFF) + ((by2 & 0xFF) << 8);
        }
        return ((by & 0xFF) << 8) + (by2 & 0xFF);
    }

    public static int bytesToInt(byte by, byte by2, byte by3, boolean bl) {
        if (bl) {
            return (by & 0xFF) + ((by2 & 0xFF) << 8) + (by3 << 16);
        }
        return (by << 16) + ((by2 & 0xFF) << 8) + (by3 & 0xFF);
    }

    public static int bytesToInt(byte by, byte by2, byte by3, byte by4, boolean bl) {
        if (bl) {
            return (by & 0xFF) + ((by2 & 0xFF) << 8) + ((by3 & 0xFF) << 16) + ((by4 & 0xFF) << 24);
        }
        return ((by & 0xFF) << 24) + ((by2 & 0xFF) << 16) + ((by3 & 0xFF) << 8) + (by4 & 0xFF);
    }

    public static long bytesToLong(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, boolean bl) {
        if (bl) {
            return ((long)by & 0xFFL) + (((long)by2 & 0xFFL) << 8) + (((long)by3 & 0xFFL) << 16) + (((long)by4 & 0xFFL) << 24) + (((long)by5 & 0xFFL) << 32) + (((long)by6 & 0xFFL) << 40) + (((long)by7 & 0xFFL) << 48) + (((long)by8 & 0xFFL) << 56);
        }
        return (((long)by & 0xFFL) << 56) + (((long)by2 & 0xFFL) << 48) + (((long)by3 & 0xFFL) << 40) + (((long)by4 & 0xFFL) << 32) + (((long)by5 & 0xFFL) << 24) + (((long)by6 & 0xFFL) << 16) + (((long)by7 & 0xFFL) << 8) + ((long)by8 & 0xFFL);
    }

    public static float bytesToFloat(byte by, byte by2, byte by3, byte by4, boolean bl) {
        return Float.intBitsToFloat(Utility.bytesToInt(by, by2, by3, by4, bl));
    }

    public static double bytesToDouble(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, boolean bl) {
        return Double.longBitsToDouble(Utility.bytesToLong(by, by2, by3, by4, by5, by6, by7, by8, bl));
    }

    public static double bytesToDouble(byte[] byArray, int n, boolean bl) {
        return Double.longBitsToDouble(Utility.bytesToLong(byArray, n, bl));
    }

    public static float bytesToFloat(byte[] byArray, int n, boolean bl) {
        return Float.intBitsToFloat(Utility.bytesToInt(byArray, n, bl));
    }

    public static byte[] intToByteArray(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public static byte[] floatToByteArray(float f) {
        return Utility.intToByteArray(Float.floatToIntBits(f));
    }

    public static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[]{(byte)(l >>> 56 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return byArray;
    }

    public static byte[] doubleToByteArray(double d) {
        return Utility.longToByteArray(Double.doubleToLongBits(d));
    }

    public static void insertFloat(float f, byte[] byArray, int n) {
        int n2 = Float.floatToIntBits(f);
        byte[] byArray2 = Utility.intToByteArray(n2);
        System.arraycopy(byArray2, 0, byArray, n, 4);
    }

    public static byte[] pad(byte[] byArray, int n, byte by) {
        if (byArray.length == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (int i = byArray.length; i < n; ++i) {
            byArray2[i] = by;
        }
        return byArray2;
    }

    public static byte[] format(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n - n2 + 1];
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            byArray2[n3] = byArray[n4];
            ++n4;
            ++n3;
        }
        return byArray2;
    }

    public static boolean areContiguous(DataRecord dataRecord, DataRecord dataRecord2) {
        Btime btime = dataRecord.getHeader().getPredictedNextStartBtime();
        Btime btime2 = dataRecord2.getHeader().getStartBtime();
        return btime.tenthMilli == btime2.tenthMilli && btime.sec == btime2.sec && btime.min == btime2.min && btime.hour == btime2.hour && btime.jday == btime2.jday && btime.year == btime2.year;
    }

    public static List<List<DataRecord>> breakContiguous(List<DataRecord> list) {
        ArrayList<List<DataRecord>> arrayList = new ArrayList<List<DataRecord>>();
        ArrayList<DataRecord> arrayList2 = new ArrayList<DataRecord>();
        DataRecord dataRecord = null;
        for (DataRecord dataRecord2 : list) {
            if (dataRecord == null) {
                arrayList.add(arrayList2);
            } else if (!Utility.areContiguous(dataRecord, dataRecord2)) {
                arrayList2 = new ArrayList();
                arrayList.add(arrayList2);
            }
            arrayList2.add(dataRecord2);
            dataRecord = dataRecord2;
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        int n = 256;
        byte by = (byte)((n & 0xFF000000) >> 24);
        byte by2 = (byte)((n & 0xFF0000) >> 16);
        byte by3 = (byte)((n & 0xFF00) >> 8);
        byte by4 = (byte)(n & 0xFF);
        System.out.println("first byte is " + by);
        System.out.println("2 byte is " + by2);
        System.out.println("3 byte is " + by3);
        System.out.println("4  byte is " + by4);
        byte[] byArray = new byte[5];
        for (int i = 0; i < 5; ++i) {
            byArray[i] = 10;
        }
        byte[] byArray2 = Utility.pad(byArray, 5, (byte)32);
        for (int i = byArray2.length - 1; i > -1; --i) {
            System.out.println("byte" + i + " " + byArray2[i]);
        }
    }

    public static void cleanDuplicatesOverlaps(List<DataRecord> list) {
        Collections.sort(list, new DataRecordBeginComparator());
        DataRecord dataRecord = null;
        Iterator<DataRecord> iterator = list.iterator();
        while (iterator.hasNext()) {
            DataRecord dataRecord2 = iterator.next();
            if (dataRecord != null && dataRecord.getHeader().getStartBtime().equals(dataRecord2.getHeader().getStartBtime())) {
                iterator.remove();
                continue;
            }
            if (dataRecord != null && dataRecord.getHeader().getLastSampleBtime().afterOrEquals(dataRecord2.getHeader().getStartBtime())) {
                iterator.remove();
                continue;
            }
            dataRecord = dataRecord2;
        }
    }
}

