/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.BlocketteFactory;
import edu.sc.seis.seisFile.mseed.ControlHeader;
import edu.sc.seis.seisFile.mseed.ControlRecord;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.DefaultBlocketteFactory;
import edu.sc.seis.seisFile.mseed.MissingBlockette1000;
import edu.sc.seis.seisFile.mseed.PartialBlockette;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class SeedRecord {
    protected static BlocketteFactory blocketteFactory = new DefaultBlocketteFactory();
    protected static SeedRecord priorRecord = null;
    protected ControlHeader header;
    protected List<Blockette> blockettes = new ArrayList<Blockette>();
    protected int RECORD_SIZE = 4096;

    public static void setBlocketteFactory(BlocketteFactory blocketteFactory) {
        SeedRecord.blocketteFactory = blocketteFactory;
    }

    public static BlocketteFactory getBlocketteFactory() {
        return blocketteFactory;
    }

    public static SeedRecord read(DataInput dataInput) throws IOException, SeedFormatException {
        return SeedRecord.read(dataInput, 0);
    }

    public static SeedRecord read(byte[] byArray) throws IOException, SeedFormatException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        return DataRecord.read(dataInputStream);
    }

    public static SeedRecord read(DataInput dataInput, int n) throws IOException, SeedFormatException {
        boolean bl;
        boolean bl2 = bl = dataInput instanceof DataInputStream && ((InputStream)((Object)dataInput)).markSupported();
        if (bl) {
            ((InputStream)((Object)dataInput)).mark(4096);
        }
        try {
            SeedRecord seedRecord;
            ControlHeader controlHeader = ControlHeader.read(dataInput);
            if (controlHeader instanceof DataHeader) {
                seedRecord = DataRecord.readDataRecord(dataInput, (DataHeader)controlHeader, n);
            } else {
                ControlRecord controlRecord = ControlRecord.readControlRecord(dataInput, controlHeader, n, priorRecord);
                n = controlRecord.getRecordSize();
                seedRecord = controlRecord;
            }
            priorRecord = seedRecord;
            return priorRecord;
        }
        catch (SeedFormatException seedFormatException) {
            if (bl) {
                try {
                    ((InputStream)((Object)dataInput)).reset();
                }
                catch (IOException iOException) {
                    throw seedFormatException;
                }
            }
            throw seedFormatException;
        }
        catch (IOException iOException) {
            if (bl) {
                try {
                    ((InputStream)((Object)dataInput)).reset();
                }
                catch (IOException iOException2) {
                    throw iOException;
                }
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                try {
                    ((InputStream)((Object)dataInput)).reset();
                }
                catch (IOException iOException) {
                    throw runtimeException;
                }
            }
            throw runtimeException;
        }
    }

    public SeedRecord(ControlHeader controlHeader) {
        this.header = controlHeader;
    }

    public void addBlockette(Blockette blockette) throws SeedFormatException {
        this.blockettes.add(blockette);
    }

    public Blockette[] getBlockettes() {
        return this.blockettes.toArray(new Blockette[0]);
    }

    public Blockette getUniqueBlockette(int n) throws SeedFormatException {
        Blockette[] blocketteArray = this.getBlockettes(n);
        if (blocketteArray.length == 1) {
            return blocketteArray[0];
        }
        if (blocketteArray.length == 0) {
            if (n == 1000) {
                throw new MissingBlockette1000();
            }
            throw new SeedFormatException("No blockettes of type " + n);
        }
        throw new SeedFormatException("Multiple blockettes of type " + n);
    }

    public int getNumBlockettes(int n) throws SeedFormatException {
        int n2 = 0;
        for (Blockette blockette : this.blockettes) {
            if (blockette.getType() != n) continue;
            ++n2;
        }
        return n2;
    }

    public Blockette[] getBlockettes(int n) {
        ArrayList<Blockette> arrayList = new ArrayList<Blockette>();
        for (Blockette blockette : this.blockettes) {
            if (blockette.getType() != n) continue;
            arrayList.add(blockette);
        }
        return arrayList.toArray(new Blockette[0]);
    }

    public PartialBlockette getFirstPartialBlockette() {
        if (this.blockettes.get(0) instanceof PartialBlockette) {
            return (PartialBlockette)this.blockettes.get(0);
        }
        return null;
    }

    public PartialBlockette getLastPartialBlockette() {
        if (this.blockettes.get(this.blockettes.size() - 1) instanceof PartialBlockette) {
            return (PartialBlockette)this.blockettes.get(this.blockettes.size() - 1);
        }
        return null;
    }

    public ControlHeader getControlHeader() {
        return this.header;
    }

    public String toString() {
        String string = "Record for " + this.header + "\n";
        string = string + "Blockettes:\n";
        for (int i = 0; i < this.blockettes.size(); ++i) {
            string = string + this.blockettes.get(i) + "\n";
        }
        return string;
    }

    public void writeASCII(PrintWriter printWriter) throws IOException {
        this.writeASCII(printWriter, "");
    }

    public void writeASCII(PrintWriter printWriter, String string) throws IOException {
        if (this instanceof DataRecord) {
            printWriter.print(string + "DataRecord");
        } else if (this instanceof ControlRecord) {
            printWriter.print(string + "ControlRecord");
        } else {
            printWriter.print(string + "SeedRecord");
        }
        this.getControlHeader().writeASCII(printWriter, string + "  ");
        for (Blockette blockette : this.blockettes) {
            blockette.writeASCII(printWriter, string + "    ");
        }
    }

    public int getRecordSize() {
        return this.RECORD_SIZE;
    }
}

