/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.MissingBlockette1000;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class MiniSeedRead {
    protected int numRead = 0;
    protected DataInput inStream;
    protected int recordSize;
    protected boolean readData;

    protected MiniSeedRead() {
    }

    public MiniSeedRead(DataInput dataInput) throws IOException {
        this.inStream = dataInput;
    }

    public void close() throws IOException {
        this.inStream = null;
    }

    public SeedRecord getNextRecord() throws SeedFormatException, IOException {
        return this.getNextRecord(0);
    }

    public SeedRecord getNextRecord(int n) throws SeedFormatException, IOException {
        return SeedRecord.read(this.inStream, n);
    }

    public int getNumRecordsRead() {
        return this.numRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        FilterInputStream filterInputStream = null;
        PrintWriter printWriter = new PrintWriter(System.out, true);
        int n = -1;
        try {
            printWriter.println("open socket");
            if (stringArray.length == 0) {
                printWriter.println("Usage: java " + MiniSeedRead.class.getName() + " filename");
            } else {
                filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(stringArray[0]), 4096));
            }
            MiniSeedRead miniSeedRead = new MiniSeedRead((DataInput)((Object)filterInputStream));
            for (int i = 0; n == -1 || i < n; ++i) {
                SeedRecord seedRecord;
                try {
                    seedRecord = miniSeedRead.getNextRecord();
                }
                catch (MissingBlockette1000 missingBlockette1000) {
                    printWriter.println("Missing Blockette1000, trying with record size of 4096");
                    seedRecord = miniSeedRead.getNextRecord(4096);
                }
                seedRecord.writeASCII(printWriter, "    ");
                if (!(seedRecord instanceof DataRecord)) continue;
                DataRecord dataRecord = (DataRecord)seedRecord;
                byte[] byArray = dataRecord.getData();
            }
        }
        catch (EOFException eOFException) {
            System.out.println("EOF, so done.");
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

