/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette10;
import edu.sc.seis.seisFile.mseed.Blockette100;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Blockette1001;
import edu.sc.seis.seisFile.mseed.Blockette200;
import edu.sc.seis.seisFile.mseed.Blockette2000;
import edu.sc.seis.seisFile.mseed.Blockette5;
import edu.sc.seis.seisFile.mseed.Blockette8;
import edu.sc.seis.seisFile.mseed.BlocketteFactory;
import edu.sc.seis.seisFile.mseed.BlocketteUnknown;
import edu.sc.seis.seisFile.mseed.DataBlocketteUnknown;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.IOException;

public class DefaultBlocketteFactory
implements BlocketteFactory {
    @Override
    public Blockette parseBlockette(int n, byte[] byArray, boolean bl) throws IOException, SeedFormatException {
        switch (n) {
            case 5: {
                return new Blockette5(byArray);
            }
            case 8: {
                return new Blockette8(byArray);
            }
            case 10: {
                return new Blockette10(byArray);
            }
            case 100: {
                return new Blockette100(byArray, bl);
            }
            case 200: {
                return new Blockette200(byArray, bl);
            }
            case 1000: {
                return new Blockette1000(byArray, bl);
            }
            case 1001: {
                return new Blockette1001(byArray, bl);
            }
            case 2000: {
                return new Blockette2000(byArray, bl);
            }
        }
        if (n < 100) {
            return new BlocketteUnknown(byArray, n, bl);
        }
        return new DataBlocketteUnknown(byArray, n, bl);
    }
}

