/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.BlocketteUnknown;
import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.DataBlocketteUnknown;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.MissingBlockette1000;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;

public class DataRecord
extends SeedRecord
implements Serializable {
    protected byte[] data;
    byte ZERO_BYTE = 0;
    private static DecimalFormat byteFormat = new DecimalFormat("000");

    public DataRecord(DataHeader dataHeader) {
        super(dataHeader);
    }

    public DataRecord(DataRecord dataRecord) {
        super(new DataHeader(dataRecord.getHeader().getSequenceNum(), dataRecord.getHeader().getTypeCode(), dataRecord.getHeader().isContinuation()));
        this.RECORD_SIZE = dataRecord.RECORD_SIZE;
        this.getHeader().setActivityFlags(dataRecord.getHeader().getActivityFlags());
        this.getHeader().setChannelIdentifier(dataRecord.getHeader().getChannelIdentifier());
        this.getHeader().setDataBlocketteOffset((short)dataRecord.getHeader().getDataBlocketteOffset());
        this.getHeader().setDataOffset((short)dataRecord.getHeader().getDataOffset());
        this.getHeader().setDataQualityFlags(dataRecord.getHeader().getDataQualityFlags());
        this.getHeader().setIOClockFlags(dataRecord.getHeader().getIOClockFlags());
        this.getHeader().setLocationIdentifier(dataRecord.getHeader().getLocationIdentifier());
        this.getHeader().setNetworkCode(dataRecord.getHeader().getNetworkCode());
        this.getHeader().setNumSamples((short)dataRecord.getHeader().getNumSamples());
        this.getHeader().setSampleRateFactor((short)dataRecord.getHeader().getSampleRateFactor());
        this.getHeader().setSampleRateMultiplier((short)dataRecord.getHeader().getSampleRateMultiplier());
        this.getHeader().setStartBtime(dataRecord.getHeader().getStartBtime());
        this.getHeader().setStationIdentifier(dataRecord.getHeader().getStationIdentifier());
        this.getHeader().setTimeCorrection(dataRecord.getHeader().getTimeCorrection());
        try {
            this.setData(dataRecord.getData());
            for (int i = 0; i < dataRecord.getBlockettes().length; ++i) {
                this.blockettes.add(dataRecord.getBlockettes()[i]);
            }
        }
        catch (SeedFormatException seedFormatException) {
            throw new RuntimeException("Shouldn't happen as record was valid and we are copying it");
        }
    }

    @Override
    public void addBlockette(Blockette blockette) throws SeedFormatException {
        if (blockette == null) {
            throw new IllegalArgumentException("Blockette cannot be null");
        }
        if (blockette instanceof BlocketteUnknown) {
            blockette = new DataBlocketteUnknown(((BlocketteUnknown)blockette).info, blockette.getType(), ((BlocketteUnknown)blockette).getSwapBytes());
        }
        if (!(blockette instanceof DataBlockette)) {
            throw new SeedFormatException("Cannot add non-data blockettes to a DataRecord " + blockette.getType());
        }
        super.addBlockette(blockette);
        this.getHeader().setNumBlockettes((byte)(this.getHeader().getNumBlockettes() + 1));
        if (blockette instanceof Blockette1000) {
            this.RECORD_SIZE = ((Blockette1000)blockette).getLogicalRecordLength();
        }
        this.recheckDataOffset();
    }

    protected void recheckDataOffset() throws SeedFormatException {
        int n = this.getHeader().getSize();
        Blockette[] blocketteArray = this.getBlockettes();
        for (int i = 0; i < blocketteArray.length; ++i) {
            n += blocketteArray[i].getSize();
        }
        if (this.data != null) {
            n += this.data.length;
        }
        if (n > this.RECORD_SIZE) {
            throw new SeedFormatException("Can't fit blockettes and data in record " + n);
        }
        if (this.data != null) {
            this.getHeader().setDataOffset((short)(this.RECORD_SIZE - this.data.length));
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) throws SeedFormatException {
        this.data = byArray;
        this.recheckDataOffset();
    }

    public int getDataSize() {
        return this.data.length;
    }

    public DataHeader getHeader() {
        return (DataHeader)this.header;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        Blockette[] blocketteArray = this.getBlockettes();
        this.getHeader().setNumBlockettes((byte)blocketteArray.length);
        if (blocketteArray.length != 0) {
            this.getHeader().setDataBlocketteOffset((short)48);
        }
        this.getHeader().write(dataOutputStream);
        short s = this.getHeader().getSize();
        for (n = 0; n < blocketteArray.length; ++n) {
            DataBlockette dataBlockette = (DataBlockette)blocketteArray[n];
            s = (short)(s + (short)dataBlockette.getSize());
            if (n != blocketteArray.length - 1) {
                dataOutputStream.write(dataBlockette.toBytes(s));
                continue;
            }
            dataOutputStream.write(dataBlockette.toBytes((short)0));
        }
        for (n = (int)s; n < this.getHeader().getDataOffset(); ++n) {
            dataOutputStream.write(this.ZERO_BYTE);
        }
        dataOutputStream.write(this.data);
        n = this.RECORD_SIZE - this.getHeader().getDataOffset() - this.data.length;
        for (int i = 0; i < n; ++i) {
            dataOutputStream.write(this.ZERO_BYTE);
        }
    }

    public void writeData(PrintWriter printWriter) {
        byte[] byArray = this.getData();
        for (int i = 0; i < byArray.length; ++i) {
            printWriter.write(byteFormat.format(0xFF & byArray[i]) + " ");
            if (i % 4 == 3) {
                printWriter.write("  ");
            }
            if (i % 16 != 15 || i == 0) continue;
            printWriter.write("\n");
        }
    }

    public static SeedRecord readDataRecord(DataInput dataInput, DataHeader dataHeader, int n) throws IOException, SeedFormatException {
        try {
            byte[] byArray;
            byte[] byArray2;
            int n2;
            byte[] byArray3;
            boolean bl = dataHeader.flagByteSwap();
            DataRecord dataRecord = new DataRecord(dataHeader);
            if (dataHeader.getDataBlocketteOffset() != 0 && (byArray3 = new byte[dataHeader.getDataBlocketteOffset() - dataHeader.getSize()]).length != 0) {
                dataInput.readFully(byArray3);
            }
            int n3 = dataHeader.getDataBlocketteOffset();
            if (dataHeader.getDataBlocketteOffset() == 0) {
                n3 = dataHeader.getSize();
            }
            for (n2 = 0; n2 < dataHeader.getNumBlockettes(); ++n2) {
                byte by = dataInput.readByte();
                byte by2 = dataInput.readByte();
                int n4 = Utility.uBytesToInt(by, by2, bl);
                byte by3 = dataInput.readByte();
                byte by4 = dataInput.readByte();
                int n5 = Utility.uBytesToInt(by3, by4, bl);
                byArray3 = n5 != 0 ? new byte[n5 - n3] : (dataHeader.getDataOffset() > n3 ? new byte[dataHeader.getDataOffset() - (n3 += 4)] : new byte[]{});
                dataInput.readFully(byArray3);
                n3 = n5 != 0 ? n5 : (n3 += byArray3.length);
                byte[] byArray4 = new byte[byArray3.length + 4];
                System.arraycopy(byArray3, 0, byArray4, 4, byArray3.length);
                byArray4[0] = by;
                byArray4[1] = by2;
                byArray4[2] = by3;
                byArray4[3] = by4;
                Blockette blockette = SeedRecord.getBlocketteFactory().parseBlockette(n4, byArray4, bl);
                dataRecord.blockettes.add(blockette);
                if (n5 == 0) break;
            }
            n2 = n;
            try {
                n2 = ((Blockette1000)dataRecord.getUniqueBlockette(1000)).getDataRecordLength();
            }
            catch (MissingBlockette1000 missingBlockette1000) {
                if (n == 0) {
                    throw missingBlockette1000;
                }
                n2 = n;
            }
            dataRecord.RECORD_SIZE = n2;
            if (dataHeader.getDataOffset() != 0 && (byArray2 = new byte[dataHeader.getDataOffset() - n3]).length != 0) {
                dataInput.readFully(byArray2);
            }
            if (dataHeader.getDataOffset() == 0) {
                byArray = new byte[n2 - n3];
            } else {
                if (n2 < dataHeader.getDataOffset()) {
                    throw new SeedFormatException("recordSize < header.getDataOffset(): " + n2 + " < " + dataHeader.getDataOffset());
                }
                byArray = new byte[n2 - dataHeader.getDataOffset()];
            }
            dataInput.readFully(byArray);
            dataRecord.setData(byArray);
            return dataRecord;
        }
        catch (SeedFormatException seedFormatException) {
            seedFormatException.setHeader(dataHeader);
            throw seedFormatException;
        }
    }

    public void setRecordSize(int n) throws SeedFormatException {
        int n2 = this.RECORD_SIZE;
        this.RECORD_SIZE = n;
        try {
            this.recheckDataOffset();
        }
        catch (SeedFormatException seedFormatException) {
            this.RECORD_SIZE = n2;
            throw seedFormatException;
        }
    }

    @Override
    public String toString() {
        String string = "Data " + super.toString();
        string = string + "\n" + this.data.length + " bytes of data read.";
        return string;
    }
}

