/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.BtimeRange;
import edu.sc.seis.seisFile.mseed.ControlHeader;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;

public class DataHeader
extends ControlHeader {
    protected byte[] stationIdentifier = new byte[5];
    protected String stationIdentifierString;
    protected byte[] locationIdentifier = new byte[2];
    protected String locationIdentifierString;
    protected byte[] channelIdentifier = new byte[3];
    protected String channelIdentifierString;
    protected byte[] networkCode = new byte[2];
    protected String networkCodeString;
    protected byte[] startTime = new byte[10];
    protected int numSamples;
    protected int sampleRateFactor;
    protected int sampleRateMultiplier;
    protected byte activityFlags;
    protected byte ioClockFlags;
    protected byte dataQualityFlags;
    protected byte numBlockettes;
    protected int timeCorrection;
    protected int dataOffset;
    protected int dataBlocketteOffset;

    public DataHeader(int n, char c, boolean bl) {
        super(n, c, bl);
    }

    @Override
    public void writeASCII(PrintWriter printWriter) throws IOException {
        this.writeASCII(printWriter, "");
    }

    @Override
    public void writeASCII(PrintWriter printWriter, String string) throws IOException {
        super.writeASCII(printWriter, string);
        printWriter.print(string + this.getNetworkCode().trim() + "." + this.getStationIdentifier().trim() + "." + this.getLocationIdentifier() + "." + this.getChannelIdentifier());
        printWriter.print(" start=" + this.getStartTime());
        printWriter.print(" numPTS=" + this.getNumSamples());
        printWriter.print(" sampFac=" + this.getSampleRateFactor());
        printWriter.print(" sampMul=" + this.getSampleRateMultiplier());
        printWriter.print(" ac=" + this.getActivityFlags());
        printWriter.print(" io=" + this.getIOClockFlags());
        printWriter.print(" qual=" + this.getDataQualityFlags());
        printWriter.print(" numBlockettes=" + this.getNumBlockettes());
        printWriter.println(" tcor=" + this.getTimeCorrection());
    }

    void outwrite() {
    }

    public static DataHeader read(DataInput dataInput, int n, char c, boolean bl) throws IOException, SeedFormatException {
        byte[] byArray = new byte[40];
        dataInput.readFully(byArray);
        DataHeader dataHeader = new DataHeader(n, c, bl);
        dataHeader.read(byArray, 0);
        return dataHeader;
    }

    boolean flagByteSwap() {
        return Btime.shouldSwapBytes(this.startTime);
    }

    protected void read(byte[] byArray, int n) {
        System.arraycopy(byArray, n + 0, this.stationIdentifier, 0, this.stationIdentifier.length);
        System.arraycopy(byArray, n + 5, this.locationIdentifier, 0, this.locationIdentifier.length);
        System.arraycopy(byArray, n + 7, this.channelIdentifier, 0, this.channelIdentifier.length);
        System.arraycopy(byArray, n + 10, this.networkCode, 0, this.networkCode.length);
        System.arraycopy(byArray, n + 12, this.startTime, 0, this.startTime.length);
        boolean bl = this.flagByteSwap();
        this.numSamples = Utility.uBytesToInt(byArray[n + 22], byArray[n + 23], bl);
        this.sampleRateFactor = Utility.bytesToInt(byArray[n + 24], byArray[n + 25], bl);
        this.sampleRateMultiplier = Utility.bytesToInt(byArray[n + 26], byArray[n + 27], bl);
        this.activityFlags = byArray[n + 28];
        this.ioClockFlags = byArray[n + 29];
        this.dataQualityFlags = byArray[n + 30];
        this.numBlockettes = byArray[n + 31];
        this.timeCorrection = Utility.bytesToInt(byArray[n + 32], byArray[n + 33], byArray[n + 34], byArray[n + 35], bl);
        this.dataOffset = Utility.uBytesToInt(byArray[n + 36], byArray[n + 37], bl);
        this.dataBlocketteOffset = Utility.uBytesToInt(byArray[n + 38], byArray[n + 39], bl);
    }

    @Override
    protected void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.write(Utility.pad(this.getStationIdentifier().getBytes("ASCII"), 5, (byte)32));
        dataOutput.write(Utility.pad(this.getLocationIdentifier().getBytes("ASCII"), 2, (byte)32));
        dataOutput.write(Utility.pad(this.getChannelIdentifier().getBytes("ASCII"), 3, (byte)32));
        dataOutput.write(Utility.pad(this.getNetworkCode().getBytes("ASCII"), 2, (byte)32));
        dataOutput.write(this.startTime);
        dataOutput.writeShort((short)this.getNumSamples());
        dataOutput.writeShort((short)this.getSampleRateFactor());
        dataOutput.writeShort((short)this.getSampleRateMultiplier());
        dataOutput.writeByte(this.getActivityFlags());
        dataOutput.writeByte(this.getIOClockFlags());
        dataOutput.writeByte(this.getDataQualityFlags());
        dataOutput.writeByte(this.getNumBlockettes());
        dataOutput.writeInt(this.getTimeCorrection());
        dataOutput.writeShort((short)this.getDataOffset());
        dataOutput.writeShort((short)this.getDataBlocketteOffset());
    }

    @Override
    public short getSize() {
        return 48;
    }

    public char getQualityIndicator() {
        return this.getTypeCode();
    }

    public String getStationIdentifier() {
        if (this.stationIdentifierString == null) {
            this.stationIdentifierString = new String(this.stationIdentifier);
        }
        return this.stationIdentifierString;
    }

    public void setStationIdentifier(String string) {
        this.stationIdentifierString = string;
        try {
            this.stationIdentifier = Utility.pad(string.getBytes("ASCII"), 5, (byte)32);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Shouldn't happen", unsupportedEncodingException);
        }
    }

    public String getLocationIdentifier() {
        if (this.locationIdentifierString == null) {
            this.locationIdentifierString = new String(this.locationIdentifier);
        }
        return this.locationIdentifierString;
    }

    public void setLocationIdentifier(String string) {
        this.locationIdentifierString = string;
        int n = 2;
        try {
            this.locationIdentifier = Utility.pad(string.getBytes("ASCII"), n, (byte)32);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Shouldn't happen", unsupportedEncodingException);
        }
    }

    public String getChannelIdentifier() {
        if (this.channelIdentifierString == null) {
            this.channelIdentifierString = new String(this.channelIdentifier);
        }
        return this.channelIdentifierString;
    }

    public void setChannelIdentifier(String string) {
        this.channelIdentifierString = string;
        int n = 3;
        try {
            this.channelIdentifier = Utility.pad(string.getBytes("ASCII"), n, (byte)32);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Shouldn't happen", unsupportedEncodingException);
        }
    }

    public String getNetworkCode() {
        if (this.networkCodeString == null) {
            this.networkCodeString = new String(this.networkCode);
        }
        return this.networkCodeString;
    }

    public void setNetworkCode(String string) {
        this.networkCodeString = string;
        int n = 2;
        byte by = 32;
        try {
            this.networkCode = Utility.pad(string.getBytes("ASCII"), n, by);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Shouldn't happen", unsupportedEncodingException);
        }
    }

    public Btime getStartBtime() {
        return new Btime(this.startTime);
    }

    public void setStartBtime(Btime btime) {
        this.startTime = btime.getAsBytes();
    }

    public float getSampleRate() {
        double d = this.getSampleRateFactor();
        double d2 = this.getSampleRateMultiplier();
        float f = 10000.0f;
        if (d * d2 != 0.0) {
            f = (float)(Math.pow(Math.abs(d), d / Math.abs(d)) * Math.pow(Math.abs(d2), d2 / Math.abs(d2)));
        }
        return f;
    }

    private double ttConvert(Btime btime) {
        double d = (double)btime.jday * 8.64E8;
        d += (double)btime.hour * 3.6E7;
        d += (double)btime.min * 600000.0;
        d += (double)btime.sec * 10000.0;
        return d += (double)btime.tenthMilli;
    }

    private Btime projectTime(Btime btime, double d) {
        boolean bl;
        int n = 0;
        boolean bl2 = bl = btime.year % 4 == 0 && btime.year % 100 != 0 || btime.year % 400 == 0;
        if (bl) {
            n = 1;
        }
        if ((d += this.ttConvert(btime)) >= (double)(366 + n) * 8.64E8) {
            ++btime.year;
            d -= (double)(365 + n) * 8.64E8;
        }
        btime.jday = (int)(d / 8.64E8);
        btime.hour = (int)((d -= (double)btime.jday * 8.64E8) / 3.6E7);
        btime.min = (int)((d -= (double)btime.hour * 3.6E7) / 600000.0);
        btime.sec = (int)((d -= (double)btime.min * 600000.0) / 10000.0);
        btime.tenthMilli = (int)(d -= (double)btime.sec * 10000.0);
        return btime;
    }

    private Btime getEndBtime() {
        Btime btime = this.getStartBtime();
        double d = (double)this.getNumSamples() / (double)this.getSampleRate() * 10000.0;
        return this.projectTime(btime, d);
    }

    public Btime getPredictedNextStartBtime() {
        return this.getEndBtime();
    }

    public BtimeRange getBtimeRange() {
        return new BtimeRange(this.getStartBtime(), this.getLastSampleBtime());
    }

    public Btime getLastSampleBtime() {
        Btime btime = this.getStartBtime();
        double d = (double)(this.getNumSamples() - 1) / (double)this.getSampleRate() * 10000.0;
        return this.projectTime(btime, d);
    }

    public String getStartTime() {
        Btime btime = this.getStartBtime();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        DecimalFormat decimalFormat2 = new DecimalFormat("000");
        DecimalFormat decimalFormat3 = new DecimalFormat("0000");
        return new String(decimalFormat3.format(btime.year) + "," + decimalFormat2.format(btime.jday) + "," + decimalFormat.format(btime.hour) + ":" + decimalFormat.format(btime.min) + ":" + decimalFormat.format(btime.sec) + "." + decimalFormat3.format(btime.tenthMilli));
    }

    public String getEndTime() {
        Btime btime = this.getEndBtime();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        DecimalFormat decimalFormat2 = new DecimalFormat("000");
        DecimalFormat decimalFormat3 = new DecimalFormat("0000");
        return new String(decimalFormat3.format(btime.year) + "," + decimalFormat2.format(btime.jday) + "," + decimalFormat.format(btime.hour) + ":" + decimalFormat.format(btime.min) + ":" + decimalFormat.format(btime.sec) + "." + decimalFormat3.format(btime.tenthMilli));
    }

    public String getLastSampleTime() {
        Btime btime = this.getLastSampleBtime();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        DecimalFormat decimalFormat2 = new DecimalFormat("000");
        DecimalFormat decimalFormat3 = new DecimalFormat("0000");
        return new String(decimalFormat3.format(btime.year) + "," + decimalFormat2.format(btime.jday) + "," + decimalFormat.format(btime.hour) + ":" + decimalFormat.format(btime.min) + ":" + decimalFormat.format(btime.sec) + "." + decimalFormat3.format(btime.tenthMilli));
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(short s) {
        this.numSamples = s;
    }

    public int getSampleRateFactor() {
        return this.sampleRateFactor;
    }

    public void setSampleRateFactor(short s) {
        this.sampleRateFactor = s;
    }

    public int getSampleRateMultiplier() {
        return this.sampleRateMultiplier;
    }

    public void setSampleRateMultiplier(short s) {
        this.sampleRateMultiplier = s;
    }

    public void setSampleRate(double d) {
        short[] sArray = DataHeader.calcSeedMultipilerFactor(d);
        this.setSampleRateFactor(sArray[0]);
        this.setSampleRateMultiplier(sArray[1]);
    }

    public static short[] calcSeedMultipilerFactor(double d) {
        if (d >= 1.0) {
            int n = (int)Math.ceil(-32766.0 / d);
            if (n < -32766) {
                n = -32766;
            }
            int n2 = (int)Math.round(-1.0 * d * (double)n);
            return new short[]{(short)n2, (short)n};
        }
        int n = -1 * (int)Math.round(Math.floor(1.0 * d * 32765.0) / d);
        if (n > 32765) {
            n = 32765;
        }
        int n3 = (int)Math.round((double)(-1 * n) * d);
        return new short[]{(short)n, (short)n3};
    }

    public byte getActivityFlags() {
        return this.activityFlags;
    }

    public void setActivityFlags(byte by) {
        this.activityFlags = by;
    }

    public byte getIOClockFlags() {
        return this.ioClockFlags;
    }

    public void setIOClockFlags(byte by) {
        this.ioClockFlags = by;
    }

    public byte getDataQualityFlags() {
        return this.dataQualityFlags;
    }

    public void setDataQualityFlags(byte by) {
        this.dataQualityFlags = by;
    }

    public byte getNumBlockettes() {
        return this.numBlockettes;
    }

    public void setNumBlockettes(byte by) {
        this.numBlockettes = by;
    }

    public int getTimeCorrection() {
        return this.timeCorrection;
    }

    public void setTimeCorrection(int n) {
        this.timeCorrection = n;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setDataOffset(short s) {
        this.dataOffset = s;
    }

    public int getDataBlocketteOffset() {
        return this.dataBlocketteOffset;
    }

    public void setDataBlocketteOffset(short s) {
        this.dataBlocketteOffset = s;
    }

    @Override
    public String toString() {
        String string = super.toString() + " ";
        string = string + " " + this.getNetworkCode() + "." + this.getStationIdentifier() + "." + this.getLocationIdentifier() + "." + this.getChannelIdentifier() + "." + this.getStartTime() + "  " + this.getSampleRate() * (float)this.getNumSamples() + " " + this.getNumBlockettes() + " " + this.getDataOffset() + " " + this.getDataBlocketteOffset();
        return string;
    }
}

