/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class DataBlockette
extends Blockette
implements Serializable {
    protected byte[] info;
    protected boolean swapBytes;

    public DataBlockette(byte[] byArray, boolean bl) {
        this.info = byArray;
        this.swapBytes = bl;
    }

    public DataBlockette(int n) {
        this.info = new byte[n];
        System.arraycopy(Utility.intToByteArray(this.getType()), 2, this.info, 0, 2);
    }

    protected void trimToSize(int n) throws SeedFormatException {
        if (this.info.length < n) {
            throw new SeedFormatException("Blockette " + this.getType() + " must have " + n + " bytes, but got " + this.info.length);
        }
        if (this.info.length > n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.info, 0, byArray, 0, n);
            this.info = byArray;
        }
    }

    public void write(DataOutputStream dataOutputStream, short s) throws IOException {
        dataOutputStream.write(this.toBytes(s));
    }

    public byte[] toBytes(short s) {
        System.arraycopy(Utility.intToByteArray(s), 2, this.info, 2, 2);
        return this.info;
    }

    @Override
    public byte[] toBytes() {
        return this.toBytes((short)0);
    }
}

