/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;

public class ControlHeader {
    protected int sequenceNum;
    protected byte typeCode;
    protected boolean continuationCode;

    public static ControlHeader read(DataInput dataInput) throws IOException, SeedFormatException {
        boolean bl;
        byte[] byArray = new byte[6];
        dataInput.readFully(byArray);
        String string = new String(byArray);
        int n = 0;
        if (!string.equals("      ")) {
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("seq num unreadable, setting to 0 " + numberFormatException.toString());
            }
        }
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        if (by2 == 32) {
            bl = false;
        } else if (by2 == 42) {
            bl = true;
        } else {
            throw new SeedFormatException("ControlHeader, expected space or *, but got " + by2);
        }
        if (by == 68 || by == 82 || by == 81 || by == 77) {
            return DataHeader.read(dataInput, n, (char)by, bl);
        }
        return new ControlHeader(n, by, bl);
    }

    protected void write(DataOutput dataOutput) throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        String string = decimalFormat.format(this.getSequenceNum());
        byte[] byArray = null;
        try {
            byArray = string.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        int n = this.continuationCode ? 42 : 32;
        try {
            dataOutput.write(byArray);
            dataOutput.write(this.typeCode);
            dataOutput.write(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeASCII(PrintWriter printWriter) throws IOException {
        this.writeASCII(printWriter, "");
    }

    public void writeASCII(PrintWriter printWriter, String string) throws IOException {
        printWriter.print(string + "seq=" + this.getSequenceNum());
        printWriter.print(" type=" + this.getTypeCode());
        printWriter.println(" cont=" + this.isContinuation());
    }

    public ControlHeader(int n, byte by, boolean bl) {
        this.sequenceNum = n;
        this.typeCode = by;
        this.continuationCode = bl;
    }

    public ControlHeader(int n, char c, boolean bl) {
        this(n, (byte)c, bl);
    }

    public short getSize() {
        return 8;
    }

    public int getSequenceNum() {
        return this.sequenceNum;
    }

    public char getTypeCode() {
        return (char)this.typeCode;
    }

    public boolean isContinuation() {
        return this.continuationCode;
    }

    public String toString() {
        return this.getTypeCode() + "  " + this.getSequenceNum();
    }

    public static void tester(String string) {
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            ControlHeader controlHeader = new ControlHeader(23, 68, true);
            controlHeader.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ControlHeader.tester(stringArray[0]);
    }
}

