/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.BtimeComparator;
import edu.sc.seis.seisFile.mseed.Utility;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Btime {
    public int year = 1960;
    public int jday = 1;
    public int hour = 0;
    public int min = 0;
    public int sec = 0;
    public int tenthMilli = 0;
    private static BtimeComparator comparator = new BtimeComparator();

    public Btime(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        this.tenthMilli = calendar.get(14) * 10;
        this.year = calendar.get(1);
        this.jday = calendar.get(6);
        this.hour = calendar.get(11);
        this.min = calendar.get(12);
        this.sec = calendar.get(13);
    }

    public Btime() {
    }

    public Btime(int n, int n2, int n3, int n4, int n5, int n6) {
        this.year = n;
        this.jday = n2;
        this.hour = n3;
        this.min = n4;
        this.sec = n5;
        this.tenthMilli = n6;
    }

    public Btime(byte[] byArray) {
        this(byArray, 0);
    }

    public Btime(byte[] byArray, int n) {
        boolean bl = Btime.shouldSwapBytes(byArray, n);
        this.year = Utility.uBytesToInt(byArray[n], byArray[n + 1], bl);
        this.jday = Utility.uBytesToInt(byArray[n + 2], byArray[n + 3], bl);
        this.hour = byArray[n + 4] & 0xFF;
        this.min = byArray[n + 5] & 0xFF;
        this.sec = byArray[n + 6] & 0xFF;
        this.tenthMilli = Utility.uBytesToInt(byArray[n + 8], byArray[n + 9], bl);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.hour;
        n = 31 * n + this.jday;
        n = 31 * n + this.min;
        n = 31 * n + this.sec;
        n = 31 * n + this.tenthMilli;
        n = 31 * n + this.year;
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Btime) {
            Btime btime = (Btime)object;
            return btime.year == this.year && btime.jday == this.jday && btime.hour == this.hour && btime.min == this.min && btime.sec == this.sec && btime.tenthMilli == this.tenthMilli;
        }
        return false;
    }

    public boolean before(Btime btime) {
        return comparator.compare(this, btime) == -1;
    }

    public boolean after(Btime btime) {
        return comparator.compare(this, btime) == 1;
    }

    public boolean afterOrEquals(Btime btime) {
        return comparator.compare(this, btime) >= 0;
    }

    public String toString() {
        return "BTime(" + this.year + ":" + this.jday + ":" + this.hour + ":" + this.min + ":" + this.sec + "." + this.tenthMilli + ")";
    }

    public int getYear() {
        return this.year;
    }

    public int getDayOfYear() {
        return this.getJDay();
    }

    public int getJDay() {
        return this.jday;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMin() {
        return this.min;
    }

    public int getSec() {
        return this.sec;
    }

    public int getTenthMilli() {
        return this.tenthMilli;
    }

    public static boolean shouldSwapBytes(byte[] byArray) {
        return Btime.shouldSwapBytes(byArray, 0);
    }

    public static boolean shouldSwapBytes(byte[] byArray, int n) {
        int n2 = Utility.uBytesToInt(byArray[0 + n], byArray[1 + n], false);
        return n2 < 1960 || n2 > 2055;
    }

    public byte[] getAsBytes() {
        byte[] byArray = new byte[10];
        System.arraycopy(Utility.intToByteArray(this.year), 2, byArray, 0, 2);
        System.arraycopy(Utility.intToByteArray(this.jday), 2, byArray, 2, 2);
        System.arraycopy(Utility.intToByteArray(this.hour), 3, byArray, 4, 1);
        System.arraycopy(Utility.intToByteArray(this.min), 3, byArray, 5, 1);
        System.arraycopy(Utility.intToByteArray(this.sec), 3, byArray, 6, 1);
        System.arraycopy(Utility.intToByteArray(this.tenthMilli), 2, byArray, 8, 2);
        return byArray;
    }
}

