/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.ControlRecordLengthBlockette;
import edu.sc.seis.seisFile.mseed.Utility;

public class Blockette8
extends ControlRecordLengthBlockette {
    public Blockette8(byte[] byArray) {
        super(byArray);
    }

    @Override
    public int getType() {
        return 8;
    }

    public String getStationIdentifier() {
        return Utility.extractString(this.info, 13, 5);
    }

    public String getLocationIdentifier() {
        return Utility.extractString(this.info, 18, 2);
    }

    public String getChannelIdentifier() {
        return Utility.extractString(this.info, 20, 3);
    }

    public String getNetworkIdentifier() {
        return Utility.extractString(this.info, this.info.length - 2, 2);
    }

    public String getBeginningOfVolume() {
        return Utility.extractVarString(this.info, 23, 22);
    }

    public String getEndOfVolume() {
        return Utility.extractVarString(this.info, 23 + this.getBeginningOfVolume().length() + 1, 22);
    }

    public String getStationInformationEffectiveDate() {
        return Utility.extractVarString(this.info, 23 + this.getBeginningOfVolume().length() + 1 + this.getEndOfVolume().length() + 1, 22);
    }

    public String getChannelInformationEffectiveDate() {
        return Utility.extractVarString(this.info, 23 + this.getBeginningOfVolume().length() + 1 + this.getEndOfVolume().length() + 1 + this.getStationInformationEffectiveDate().length() + 1, 22);
    }

    @Override
    public String getName() {
        return "Telemetry Volume Identifier Blockette";
    }
}

