/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class Blockette2000
extends DataBlockette {
    private static final int BLOCKETTE_LENGTH = 4;
    private static final int OPAQUE_OFFSET = 6;
    private static final int NUM_HEADER_FIELD = 14;
    private static final int HEADER_FIELD = 15;
    private static final int FIXED_HEADER_LENGTH = 15;

    public Blockette2000(String[] stringArray, byte[] byArray) {
        super(byArray.length + 15 + Blockette2000.calcHeaderFieldLength(stringArray));
        System.arraycopy(Utility.intToByteArray(this.info.length), 2, this.info, 4, 2);
        this.info[14] = (byte)stringArray.length;
        int n = 15;
        for (int i = 0; i < stringArray.length; ++i) {
            byte[] byArray2;
            try {
                byArray2 = (stringArray[i] + '~').getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Java was unable to find the US-ASCII character encoding.");
            }
            System.arraycopy(byArray2, 0, this.info, n, byArray2.length);
            n += byArray2.length;
        }
        this.info[6] = (byte)n;
        System.arraycopy(byArray, 0, this.info, n, byArray.length);
    }

    private static int calcHeaderFieldLength(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < stringArray.length; ++i) {
            n += stringArray[i].length();
        }
        return n;
    }

    public Blockette2000(byte[] byArray, boolean bl) {
        super(byArray, bl);
    }

    @Override
    public String getName() {
        return "Variable Length Opaque Data Blockette";
    }

    @Override
    public int getSize() {
        return this.info.length;
    }

    @Override
    public int getType() {
        return 2000;
    }

    public String getHeaderField(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 15; n2 < this.info.length && n3 != n; ++n2) {
            if (this.info[n2] != 126) continue;
            ++n3;
        }
        int n4 = n2;
        while (this.info[n4] != 126) {
            ++n4;
        }
        return new String(this.info, n2, n4 - n2);
    }

    public int getNumHeaders() {
        return this.info[14];
    }

    public byte[] getOpaqueData() {
        byte[] byArray = new byte[this.info.length - this.info[6]];
        System.arraycopy(this.info, this.info[6], byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    public void writeASCII(PrintWriter printWriter) throws IOException {
        printWriter.print("Blockette2000 numHeaders=" + this.getNumHeaders() + " ");
        for (int i = 0; i < this.getNumHeaders(); ++i) {
            printWriter.print(this.getHeaderField(i) + ",");
        }
        printWriter.println(" " + this.getOpaqueData().length + " bytes of opaque (binary) data");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Blockette2000) {
            byte[] byArray = ((Blockette2000)object).info;
            if (this.info.length != byArray.length) {
                return false;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (this.info[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

