/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class Blockette200
extends DataBlockette {
    private static final int SIGNAL = 4;
    private static final int PERIOD = 8;
    private static final int BACKGROUND = 12;
    private static final int SIGNAL_ONSET = 18;
    private static final int EVENT_DETECTOR = 28;
    private static final int B200_SIZE = 52;
    private static final int EVENT_DETECTOR_LENGTH = 24;

    public Blockette200(float f, float f2, float f3, Btime btime, String string) {
        super(52);
        byte[] byArray;
        Utility.insertFloat(f, this.info, 4);
        Utility.insertFloat(f2, this.info, 8);
        Utility.insertFloat(f3, this.info, 12);
        byte[] byArray2 = btime.getAsBytes();
        System.arraycopy(byArray2, 0, this.info, 18, byArray2.length);
        if (string.length() > 24) {
            throw new IllegalArgumentException("The event detector can only be up to 24 characters in length");
        }
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Java was unable to find the US-ASCII character encoding.");
        }
        if (byArray.length != string.length()) {
            throw new IllegalArgumentException("The characters in event detector must be in the ASCII character set i.e. from 0-127");
        }
        byArray = Utility.pad(byArray, 24, (byte)32);
        System.arraycopy(byArray, 0, this.info, 28, byArray.length);
    }

    public Blockette200(byte[] byArray, boolean bl) throws SeedFormatException {
        super(byArray, bl);
        this.trimToSize(this.getSize());
    }

    @Override
    public String getName() {
        return "Generic Event Detection Blockette";
    }

    @Override
    public int getSize() {
        return 52;
    }

    @Override
    public int getType() {
        return 200;
    }

    public float getSignal() {
        return Float.intBitsToFloat(Utility.bytesToInt(this.info, 4, this.swapBytes));
    }

    public float getPeriod() {
        return Float.intBitsToFloat(Utility.bytesToInt(this.info, 8, this.swapBytes));
    }

    public float getBackground() {
        return Float.intBitsToFloat(Utility.bytesToInt(this.info, 12, this.swapBytes));
    }

    public Btime getSignalOnset() {
        return new Btime(this.info, 18);
    }

    public String getEventDetector() {
        return new String(this.info, 28, 24);
    }

    @Override
    public void writeASCII(PrintWriter printWriter) throws IOException {
        printWriter.println("Blockette200 sig=" + this.getSignal() + " per=" + this.getPeriod() + " bkgrd=" + this.getBackground());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Blockette200) {
            byte[] byArray = ((Blockette200)object).info;
            if (this.info.length != byArray.length) {
                return false;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (this.info[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

