/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.IOException;
import java.io.PrintWriter;

public class Blockette100
extends DataBlockette {
    public static final int B100_SIZE = 12;

    public Blockette100() {
        super(12);
    }

    public Blockette100(byte[] byArray, boolean bl) throws SeedFormatException {
        super(byArray, bl);
        this.trimToSize(12);
    }

    public void setActualSampleRate(float f) {
        Utility.insertFloat(f, this.info, 4);
    }

    public float getActualSampleRate() {
        int n = Utility.bytesToInt(this.info[4], this.info[5], this.info[6], this.info[7], false);
        return Float.intBitsToFloat(n);
    }

    @Override
    public int getType() {
        return 100;
    }

    @Override
    public int getSize() {
        return 12;
    }

    @Override
    public String getName() {
        return "Sample Rate Blockette";
    }

    @Override
    public void writeASCII(PrintWriter printWriter) throws IOException {
        printWriter.println("Blockette100 " + this.getActualSampleRate());
    }
}

