/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.liss;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Date;

public class Client {
    public static final int DEFAULT_PORT = 4000;

    public static void main(String[] stringArray) throws IOException, SeedFormatException {
        String[] stringArray2;
        String string = "IU";
        String string2 = "ANMO";
        String string3 = null;
        String string4 = null;
        String string5 = string2 + "." + string + ".liss.org";
        String string6 = null;
        int n = 4000;
        int n2 = 10;
        boolean bl = false;
        FilterOutputStream filterOutputStream = null;
        PrintWriter printWriter = new PrintWriter(System.out, true);
        if (stringArray.length == 0) {
            Client.printHelp();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-n")) {
                string = stringArray[i + 1];
                string5 = string2 + "." + string + ".liss.org";
                continue;
            }
            if (stringArray[i].equals("-s")) {
                string2 = stringArray[i + 1];
                string5 = string2 + "." + string + ".liss.org";
                continue;
            }
            if (stringArray[i].equals("-l")) {
                string3 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-c")) {
                string4 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-h")) {
                string5 = stringArray[i + 1];
                stringArray2 = string5.split("\\.");
                if (stringArray2.length != 4 || !stringArray2[2].equalsIgnoreCase("liss") || !stringArray2[3].equalsIgnoreCase("org")) continue;
                string2 = stringArray2[0];
                string = stringArray2[1];
                continue;
            }
            if (stringArray[i].equals("-p")) {
                n = Integer.parseInt(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals("-o")) {
                string6 = stringArray[i + 1];
                filterOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string6)));
                continue;
            }
            if (stringArray[i].equals("-m")) {
                n2 = Integer.parseInt(stringArray[i + 1]);
                if (n2 >= -1) continue;
                n2 = -1;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("--version")) {
                printWriter.println(BuildVersion.getDetailedVersion());
                System.exit(0);
                continue;
            }
            if (!stringArray[i].equals("--help")) continue;
            Client.printHelp();
            return;
        }
        if (bl) {
            printWriter.println("Connect to " + string5 + ":" + n);
        }
        Socket socket = new Socket(string5, n);
        stringArray2 = new DataInputStream(new BufferedInputStream(socket.getInputStream(), 1024));
        int n3 = 0;
        try {
            while ((n2 == -1 || n3 < n2) && socket.isConnected()) {
                SeedRecord seedRecord = SeedRecord.read((DataInput)stringArray2, 512);
                if (!(seedRecord instanceof DataRecord)) {
                    System.err.println("None data record found, skipping...");
                    continue;
                }
                DataRecord dataRecord = (DataRecord)seedRecord;
                if (string3 != null && !string3.equals(dataRecord.getHeader().getLocationIdentifier()) || string4 != null && !string4.equals(dataRecord.getHeader().getChannelIdentifier())) continue;
                if (filterOutputStream != null) {
                    dataRecord.write((DataOutputStream)filterOutputStream);
                }
                if (filterOutputStream == null || bl) {
                    dataRecord.writeASCII(printWriter, "    ");
                    printWriter.flush();
                }
                ++n3;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (filterOutputStream != null) {
            filterOutputStream.close();
        }
        socket.close();
        printWriter.println("Finished: " + new Date());
    }

    public static void printHelp() {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        printWriter.println("java " + Client.class.getName() + " [[-n net][-s sta]|[-h host]][-l loc][-c chan][-p port][-o outfile][-m maxpackets][--verbose][--version][--help]");
        printWriter.println(" host is formed from sta.net.liss.org if not given directly.");
        printWriter.println(" See www.liss.org for more information.");
    }
}

