/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.dataSelectWS;

import edu.sc.seis.seisFile.StringMSeedQueryReader;
import edu.sc.seis.seisFile.dataSelectWS.DataSelectException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSelectReader
extends StringMSeedQueryReader {
    protected String urlBase;
    public static final String DEFAULT_WS_URL = "http://www.iris.edu/ws/dataselect/query";
    private static final Logger logger = LoggerFactory.getLogger(DataSelectReader.class);

    public DataSelectReader() {
        this(DEFAULT_WS_URL);
    }

    public DataSelectReader(String string) {
        this.urlBase = string;
    }

    protected String createQuery(String string, String string2, String string3, String string4) throws IOException, DataSelectException, SeedFormatException {
        String string5 = "net=" + string;
        string5 = string5 + "&sta=" + string2;
        string5 = string5 + "&loc=" + string3;
        string5 = string5 + "&cha=" + string4;
        return string5;
    }

    @Override
    public String createQuery(String string, String string2, String string3, String string4, Date date, Date date2) throws IOException, DataSelectException, SeedFormatException {
        String string5 = this.createQuery(string, string2, string3, string4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        string5 = string5 + "&start=" + simpleDateFormat.format(date);
        string5 = string5 + "&end=" + simpleDateFormat.format(date2);
        return string5;
    }

    @Override
    public List<DataRecord> read(String string) throws IOException, DataSelectException, SeedFormatException {
        URL uRL = new URL(this.urlBase + "?" + string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.connect();
        if (httpURLConnection.getResponseCode() != 200) {
            if (httpURLConnection.getResponseCode() == 404) {
                logger.debug("reponseCode 404, no data");
                return new ArrayList<DataRecord>();
            }
            throw new DataSelectException("Did not get an OK repsonse code, code= :" + httpURLConnection.getResponseCode());
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        ArrayList<DataRecord> arrayList = new ArrayList<DataRecord>();
        try {
            while (true) {
                SeedRecord seedRecord;
                if ((seedRecord = SeedRecord.read(dataInputStream)) instanceof DataRecord) {
                    arrayList.add((DataRecord)seedRecord);
                    continue;
                }
                logger.warn("Not a data record, skipping..." + seedRecord.getControlHeader().getSequenceNum() + " " + seedRecord.getControlHeader().getTypeCode());
            }
        }
        catch (EOFException eOFException) {
            dataInputStream.close();
            return arrayList;
        }
    }
}

