/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.SeisFileException;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class QueryParams {
    String network;
    String station;
    String location;
    String channel;
    Date begin;
    Date end;
    Float duration = Float.valueOf(600.0f);
    int maxRecords = -1;
    String outFile = null;
    boolean verbose = false;
    boolean printVersion = false;
    boolean printHelp = false;
    DataOutputStream dos = null;

    public QueryParams(String[] stringArray) throws SeisFileException {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-n")) {
                this.network = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-s")) {
                this.station = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-l")) {
                this.location = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-c")) {
                this.channel = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-b")) {
                this.begin = this.extractDate(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals("-e")) {
                this.end = this.extractDate(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals("-d")) {
                this.duration = Float.valueOf(Float.parseFloat(stringArray[i + 1]));
                continue;
            }
            if (stringArray[i].equals("-o")) {
                this.outFile = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-m")) {
                this.maxRecords = Integer.parseInt(stringArray[i + 1]);
                if (this.maxRecords >= -1) continue;
                this.maxRecords = -1;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                this.verbose = true;
                continue;
            }
            if (stringArray[i].equals("--version")) {
                this.printVersion = true;
                continue;
            }
            if (!stringArray[i].equals("--help")) continue;
            this.printHelp = true;
        }
        if (stringArray.length == 0) {
            this.printHelp = true;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.add(13, -1 * Math.round(this.duration.floatValue()));
        gregorianCalendar.add(14, -1000 * Math.round(this.duration.floatValue() - (float)Math.round(this.duration.floatValue())));
        if (this.begin == null) {
            this.begin = gregorianCalendar.getTime();
        }
        if (this.end == null) {
            gregorianCalendar.setTime(this.begin);
            gregorianCalendar.add(13, Math.round(this.duration.floatValue()));
            gregorianCalendar.add(14, 1000 * Math.round(this.duration.floatValue() - (float)Math.round(this.duration.floatValue())));
            this.end = gregorianCalendar.getTime();
        }
    }

    public String getNetwork() {
        return this.network;
    }

    public String getStation() {
        return this.station;
    }

    public String getLocation() {
        return this.location;
    }

    public String getChannel() {
        return this.channel;
    }

    public Date getBegin() {
        return this.begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Float getDuration() {
        return this.duration;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String string) {
        this.outFile = string;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public static String getStandardHelpOptions() {
        return "[-n net][-s sta][-l loc][-c chan][-b yyyy-MM-dd[THH:mm:ss.SSS]][-e yyyy-MM-dd[THH:mm:ss.SSS]][-d seconds][-o outfile][-m maxpackets][--verbose][--version][--help]";
    }

    public DataOutputStream getDataOutputStream() throws FileNotFoundException {
        if (this.dos == null) {
            this.dos = this.getOutFile() == null ? new DataOutputStream(System.out) : new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outFile)));
        }
        return this.dos;
    }

    Date extractDate(String string) throws SeisFileException {
        SimpleDateFormat simpleDateFormat = (string = string.trim()).length() == 23 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz") : (string.length() == 19 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz") : new SimpleDateFormat("yyyy-MM-dd"));
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (string.length() > 10 && string.matches(".+\\d")) {
            string = string + " GMT";
        }
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new SeisFileException("Illegal date format, should be: yyyy-MM-dd or yyyy-MM-dd'T'HH:mm:ss or yyyy-MM-dd'T'HH:mm:ss.SSS", parseException);
        }
    }
}

