/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.MSeedQueryReader;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class MSeedQueryClient {
    protected QueryParams params;
    protected MSeedQueryReader reader;

    public MSeedQueryClient(String[] stringArray) throws SeisFileException {
        BasicConfigurator.configure();
        this.params = new QueryParams(stringArray);
        Logger.getRootLogger().setLevel(Level.WARN);
        if (this.params.isVerbose()) {
            Logger.getLogger((String)"root").setLevel(Level.DEBUG);
        }
        if (this.params.isPrintHelp()) {
            System.out.println(this.getHelp());
            System.exit(0);
        } else if (this.params.isPrintVersion()) {
            System.out.println("Version: " + BuildVersion.getDetailedVersion());
            System.exit(0);
        }
    }

    public void readData(String[] stringArray) throws SeisFileException, IOException {
        String string = "IU";
        String string2 = "ANMO";
        String string3 = "00";
        String string4 = "BHZ";
        String string5 = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.add(12, -10);
        Date date = gregorianCalendar.getTime();
        Float f = Float.valueOf(600.0f);
        int n = 10;
        boolean bl = false;
        DataOutputStream dataOutputStream = null;
        PrintWriter printWriter = new PrintWriter(System.out, true);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-n")) {
                string = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-s")) {
                string2 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-l")) {
                string3 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-c")) {
                string4 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-b")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                String string6 = stringArray[i + 1].trim();
                if (string6.matches(".+\\d")) {
                    string6 = string6 + " GMT";
                }
                try {
                    date = simpleDateFormat.parse(string6);
                    continue;
                }
                catch (ParseException parseException) {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
                    try {
                        date = simpleDateFormat.parse(string6);
                        continue;
                    }
                    catch (ParseException parseException2) {
                        throw new SeisFileException("Illegal date format, should be:  yyyy-MM-dd'T'HH:mm:ss or yyyy-MM-dd'T'HH:mm:ss.SSS", parseException2);
                    }
                }
            }
            if (stringArray[i].equals("-d")) {
                f = Float.valueOf(Float.parseFloat(stringArray[i + 1]));
                continue;
            }
            if (stringArray[i].equals("-o")) {
                string5 = stringArray[i + 1];
                dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string5)));
                continue;
            }
            if (stringArray[i].equals("-m")) {
                n = Integer.parseInt(stringArray[i + 1]);
                if (n >= -1) continue;
                n = -1;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("--version")) {
                printWriter.println(BuildVersion.getDetailedVersion());
                System.exit(0);
                continue;
            }
            if (!stringArray[i].equals("--help")) continue;
            printWriter.println(this.getHelp());
            System.exit(0);
        }
    }

    public void readData() throws SeedFormatException, IOException, SeisFileException {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        List<DataRecord> list = this.reader.read(this.params.getNetwork(), this.params.getStation(), this.params.getLocation(), this.params.getChannel(), this.params.getBegin(), this.params.getEnd());
        for (DataRecord dataRecord : list) {
            if (this.params.getDataOutputStream() != null) {
                dataRecord.write(this.params.getDataOutputStream());
            }
            if (this.params.getDataOutputStream() != null && !this.params.isVerbose()) continue;
            dataRecord.writeASCII(printWriter, "    ");
            printWriter.flush();
        }
        if (this.params.isVerbose() && list.size() == 0) {
            printWriter.println("No Data.");
            printWriter.flush();
        }
        if (this.params.getDataOutputStream() != null) {
            this.params.getDataOutputStream().flush();
        }
        if (this.params.isVerbose()) {
            printWriter.println("Finished: " + new Date());
        }
    }

    public abstract String getHelp();
}

