/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SteimFrameBlock {
    private int numFrames = 0;
    private int numSamples = 0;
    private int steimVersion = 0;
    private int currentFrame = 0;
    private SteimFrame[] steimFrame = null;

    public SteimFrameBlock(int n, int n2) {
        this.steimFrame = new SteimFrame[n];
        for (int i = 0; i < this.steimFrame.length; ++i) {
            this.steimFrame[i] = new SteimFrame();
        }
        this.numFrames = n;
        this.steimVersion = n2;
        this.currentFrame = 0;
        this.addEncodingNibble(0);
        ++this.steimFrame[this.currentFrame].pos;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public int getSteimVersion() {
        return this.steimVersion;
    }

    public byte[] getEncodedData() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.numFrames * 64);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (int i = 0; i < this.numFrames; ++i) {
            for (int j = 0; j < 16; ++j) {
                dataOutputStream.writeInt(this.steimFrame[i].word[j]);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    protected boolean addEncodedWord(int n, int n2, int n3) {
        int n4 = this.steimFrame[this.currentFrame].pos;
        this.steimFrame[this.currentFrame].word[n4] = n;
        this.addEncodingNibble(n3);
        this.numSamples += n2;
        if (++n4 > 15) {
            ++this.currentFrame;
            if (this.currentFrame >= this.numFrames) {
                return true;
            }
            this.addEncodingNibble(0);
        }
        ++this.steimFrame[this.currentFrame].pos;
        return false;
    }

    protected void setXsubN(int n) {
        this.steimFrame[0].word[2] = n;
    }

    private void addEncodingNibble(int n) {
        int n2 = this.steimFrame[this.currentFrame].pos;
        int n3 = (15 - n2) * 2;
        this.steimFrame[this.currentFrame].word[0] = this.steimFrame[this.currentFrame].word[0] | n << n3;
    }

    private class SteimFrame {
        public int[] word = new int[16];
        public int pos = 0;

        private SteimFrame() {
        }
    }
}

