/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import edu.iris.dmc.seedcodec.B1000Types;
import edu.iris.dmc.seedcodec.Cdsn;
import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.Sro;
import edu.iris.dmc.seedcodec.Steim1;
import edu.iris.dmc.seedcodec.Steim2;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.iris.dmc.seedcodec.Utility;

public class Codec
implements B1000Types {
    public DecompressedData decompress(int n, byte[] byArray, int n2, boolean bl) throws CodecException, UnsupportedCompressionType {
        DecompressedData decompressedData;
        int n3 = 0;
        switch (n) {
            case 1: 
            case 32: {
                if (byArray.length < 2 * n2) {
                    throw new CodecException("Not enough bytes for " + n2 + " 16 bit data points, only " + byArray.length + " bytes.");
                }
                short[] sArray = new short[n2];
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = Utility.bytesToShort(byArray[n3], byArray[n3 + 1], bl);
                    n3 += 2;
                }
                decompressedData = new DecompressedData(sArray);
                break;
            }
            case 2: {
                if (byArray.length < 3 * n2) {
                    throw new CodecException("Not enough bytes for " + n2 + " 24 bit data points, only " + byArray.length + " bytes.");
                }
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = Utility.bytesToInt(byArray[n3], byArray[n3 + 1], byArray[n3 + 2], bl);
                    n3 += 3;
                }
                decompressedData = new DecompressedData(nArray);
                break;
            }
            case 3: {
                if (byArray.length < 4 * n2) {
                    throw new CodecException("Not enough bytes for " + n2 + " 32 bit data points, only " + byArray.length + " bytes.");
                }
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = Utility.bytesToInt(byArray[n3], byArray[n3 + 1], byArray[n3 + 2], byArray[n3 + 3], bl);
                    n3 += 4;
                }
                decompressedData = new DecompressedData(nArray);
                break;
            }
            case 4: {
                if (byArray.length < 4 * n2) {
                    throw new CodecException("Not enough bytes for " + n2 + " 32 bit data points, only " + byArray.length + " bytes.");
                }
                float[] fArray = new float[n2];
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = Float.intBitsToFloat(Utility.bytesToInt(byArray[n3], byArray[n3 + 1], byArray[n3 + 2], byArray[n3 + 3], bl));
                    n3 += 4;
                }
                decompressedData = new DecompressedData(fArray);
                break;
            }
            case 5: {
                if (byArray.length < 8 * n2) {
                    throw new CodecException("Not enough bytes for " + n2 + " 64 bit data points, only " + byArray.length + " bytes.");
                }
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = Double.longBitsToDouble(Utility.bytesToLong(byArray[n3], byArray[n3 + 1], byArray[n3 + 2], byArray[n3 + 3], byArray[n3 + 4], byArray[n3 + 5], byArray[n3 + 6], byArray[n3 + 7], bl));
                    n3 += 8;
                }
                decompressedData = new DecompressedData(dArray);
                break;
            }
            case 10: {
                int[] nArray = Steim1.decode(byArray, n2, bl, 0);
                decompressedData = new DecompressedData(nArray);
                break;
            }
            case 11: {
                int[] nArray = Steim2.decode(byArray, n2, bl, 0);
                decompressedData = new DecompressedData(nArray);
                break;
            }
            case 16: {
                int[] nArray = Cdsn.decode(byArray, n2, bl);
                decompressedData = new DecompressedData(nArray);
                break;
            }
            case 30: {
                int[] nArray = Sro.decode(byArray, n2, bl);
                decompressedData = new DecompressedData(nArray);
                break;
            }
            default: {
                throw new UnsupportedCompressionType("Type " + n + " is not supported at this time.");
            }
        }
        return decompressedData;
    }

    public int getDecompressedType(int n) throws UnsupportedCompressionType {
        if (n == 2 || n == 3 || n == 10 || n == 11 || n == 16 || n == 30) {
            return 3;
        }
        if (n == 1 || n == 32) {
            return 1;
        }
        if (n == 4) {
            return 4;
        }
        if (n == 5) {
            return 5;
        }
        throw new UnsupportedCompressionType("Type " + n + " is not supported at this time.");
    }

    public byte[] encodeAsBytes(short[] sArray) {
        byte[] byArray = new byte[sArray.length * 2];
        for (int i = 0; i < sArray.length; ++i) {
            byArray[2 * i] = (byte)((sArray[i] & 0xFF00) >> 8);
            byArray[2 * i + 1] = (byte)(sArray[i] & 0xFF);
        }
        return byArray;
    }

    public byte[] encodeAsBytes(int[] nArray) {
        byte[] byArray = new byte[nArray.length * 4];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[4 * i] = (byte)((nArray[i] & 0xFF000000) >> 24);
            byArray[4 * i + 1] = (byte)((nArray[i] & 0xFF0000) >> 16);
            byArray[4 * i + 2] = (byte)((nArray[i] & 0xFF00) >> 8);
            byArray[4 * i + 3] = (byte)(nArray[i] & 0xFF);
        }
        return byArray;
    }

    public byte[] encodeAsBytes(float[] fArray) {
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            nArray[i] = Float.floatToIntBits(fArray[i]);
        }
        return this.encodeAsBytes(nArray);
    }

    public byte[] encodeAsBytes(double[] dArray) {
        byte[] byArray = new byte[dArray.length * 8];
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            long l = Double.doubleToLongBits(dArray[i]);
            n = 8 * i;
            byArray[n] = (byte)((l & 0xFF00000000000000L) >> 56);
            byArray[n + 1] = (byte)((l & 0xFF000000000000L) >> 48);
            byArray[n + 2] = (byte)((l & 0xFF0000000000L) >> 40);
            byArray[n + 3] = (byte)((l & 0xFF00000000L) >> 32);
            byArray[n + 4] = (byte)((l & 0xFF000000L) >> 24);
            byArray[n + 5] = (byte)((l & 0xFF0000L) >> 16);
            byArray[n + 6] = (byte)((l & 0xFF00L) >> 8);
            byArray[n + 7] = (byte)(l & 0xFFL);
        }
        return byArray;
    }
}

