/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.Utility;

public class Cdsn {
    public static final int MANTISSA_MASK = 16383;
    public static final int GAINRANGE_MASK = 3;
    public static final int SHIFT = 14;
    public static final int MAX14 = 8191;

    public static int[] decode(byte[] byArray, int n, boolean bl) throws CodecException {
        if (byArray.length < n * 2) {
            throw new CodecException("Not enough bytes for " + n + " samples, need " + 2 * n + " but only have " + byArray.length);
        }
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = 0;
            short s = Utility.bytesToShort(byArray[2 * i], byArray[2 * i + 1], bl);
            int n3 = s & 0x3FFF;
            int n4 = s >> 14 & 3;
            if (n4 == 0) {
                n2 = 0;
            } else if (n4 == 1) {
                n2 = 2;
            } else if (n4 == 2) {
                n2 = 4;
            } else if (n4 == 3) {
                n2 = 7;
            }
            nArray[i] = (n3 -= 8191) << n2;
        }
        return nArray;
    }
}

