package edu.sc.seis.gee.task.dataSetBrowser;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.task.Task;

/**
 * Description: Manages the tree browser. Shows the tree structure of DataSets
 * and allows the user to edit the tree structure by adding new empty DataSet
 * and copy and paste of seismograms. The user should click on refresh to obtain
 * data that could have been loaded by other applications of the gee. The remove
 * button does not affect the DataSet structure because it depends on
 * LocalDataSetImpl class that does not yet have implementation for remove.
 * 
 * 
 * @Created May 25, 2002
 * 
 * @author Philip Crotwell
 * @version $Id: DataSetBrowser.java 15209 2005-11-09 23:43:09Z groves $
 * 
 */
public class DataSetBrowser extends JPanel implements Task {

    /** Initialize the window */
    public DataSetBrowser() {
        setLayout(new BorderLayout());
        tree.setCellRenderer(new DataSetTreeCellRenderer());
        mediator = new TreeSelectionMediator();
        tree.addTreeSelectionListener(mediator);
        tree.setMinimumSize(new java.awt.Dimension(100, 100));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
    }
    public void configure(Map params) {}

    public void invoke() {
        if(treeModel == null) {
            refresh();
            removeAll();
            add(new JScrollPane(tree));
            revalidate();
        } // end of if (treeModel != null)
    }

    public void destroy() {
        treeModel = null;
    }

    public void refresh() {
        treeModel = new DataSetTreeModel();
        tree.setModel(treeModel);
    }

    public TreePath[] getSelectionPaths() {
        return tree.getSelectionPaths();
    }

    public void addSeismogramSelectedListener(SeismogramSelectedListener l) {
        mediator.addSeismogramSelectedListener(l);
    }

    public void removeSeismogramSelectedListener(SeismogramSelectedListener l) {
        mediator.removeSeismogramSelectedListener(l);
    }

    public void addParameterSelectedListener(ParameterSelectedListener l) {
        mediator.addParameterSelectedListener(l);
    }

    public void removeParameterSelectedListener(ParameterSelectedListener l) {
        mediator.removeParameterSelectedListener(l);
    }

    public void addDataSetSelectedListener(DataSetSelectedListener l) {
        mediator.addDataSetSelectedListener(l);
    }

    public void removeDataSetSelectedListener(DataSetSelectedListener l) {
        mediator.removeDataSetSelectedListener(l);
    }

    public DataSet[] getSelectedDataSets() {
        TreePath[] paths = tree.getSelectionPaths();
        ArrayList arrayList = new ArrayList();
        if(paths == null)
            return new DataSet[0];
        for(int counter = 0; counter < paths.length; counter++) {
            if(paths[counter].getLastPathComponent() instanceof DataSet) {
                arrayList.add(paths[counter].getLastPathComponent());
            }
        }
        return (DataSet[])arrayList.toArray(new DataSet[arrayList.size()]);
    }

    public DataSet[] getOpenDataSets() {
        int rows = tree.getRowCount();
        Set dataSets = new HashSet();
        for(int i = 0; i < rows; i++) {
            TreePath path = tree.getPathForRow(i);
            if(path.getLastPathComponent() instanceof SeismogramTreeNode) {
                SeismogramTreeNode cur = (SeismogramTreeNode)path.getLastPathComponent();
                dataSets.add(cur.getDataSet());
            }
        }
        DataSet[] dsArray = new DataSet[dataSets.size()];
        return (DataSet[])dataSets.toArray(dsArray);
    }

    public DataSetSeismogram[] getSelectedSeismograms() {
        TreePath[] paths = tree.getSelectionPaths();
        ArrayList arrayList = new ArrayList();
        if(paths == null)
            return new DataSetSeismogram[0];
        for(int counter = 0; counter < paths.length; counter++) {
            if(paths[counter].getLastPathComponent() instanceof SeismogramTreeNode) {
                SeismogramTreeNode node = (SeismogramTreeNode)paths[counter].getLastPathComponent();
                arrayList.add(node.getSeismogram());
            }
        }
        DataSetSeismogram[] seismograms = new DataSetSeismogram[arrayList.size()];
        seismograms = (DataSetSeismogram[])arrayList.toArray(seismograms);
        return seismograms;
    }

    public void expandLastRow() {
        tree.expandRow(tree.getRowCount() - 1);
    }

    private DataSetTreeModel treeModel;

    private JTree tree = new JTree();

    private TreeSelectionMediator mediator;
} /* class */
