package edu.sc.seis.gee.task;

import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Robot;
import java.util.Map;
import org.apache.log4j.Logger;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseAdapter;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;

public class ZoomInTask extends SDMouseAdapter implements Task{
    public void configure(Map params) {
        try{
            mouseMover = new Robot();
        }catch(AWTException e){
            GlobalExceptionHandler.handle("Unable to create robot!", e);
        }
        this.params = params;
        if (params.containsKey("zoomType")) {
            zoomType = (String)params.get("zoomType");
        }
    }

    public void invoke() { GlobalToolBar.setActive(this); }

    public void destroy(){}

    public void mouseClicked(SDMouseEvent me) {
        double centerPercent = me.getXPercent();
        SeismogramDisplay disp = me.getDisplay();
        if (zoomType.equalsIgnoreCase("zoomIn")) {
            disp.getTimeConfig().shaleTime(centerPercent - .25, .5);
        }else{
            disp.getTimeConfig().shaleTime(centerPercent - 1, 2);
        }
        if(mouseMover != null){
            Point loc = disp.getLocationOnScreen();
            loc.x += disp.getSize().width/2;
            loc.y += disp.getSize().height/2;
            mouseMover.mouseMove(loc.x,loc.y);
        }
    }

    public void mouseEntered(SDMouseEvent me){
        if (cursor == null) createCursor();
        me.getComponent().setCursor(cursor);
    }

    public void mouseExited(SDMouseEvent me){
        me.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    private void createCursor(){
        String imageFilePath;
        if (zoomType.equalsIgnoreCase("zoomIn")){
            imageFilePath = "edu/sc/seis/gee/data/images/pointer-mag-plus.gif";
        } else{
            imageFilePath = "edu/sc/seis/gee/data/images/pointer-mag-minus.gif";
        }
        cursor = CursorUtil.getCursor(zoomType, imageFilePath, .375f, .375f);
    }

    String zoomType = "zoomIn";

    Map params;

    private Robot mouseMover;

    Cursor cursor = null;

    private static Logger logger = Logger.getLogger(ZoomInTask.class);
}// ZoomInTask
